# observation-egfr1 - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **observation-egfr1**

## Example Observation: observation-egfr1

Language: et

Profile: [EETISObservationEGFR](StructureDefinition-ee-tis-observation-egfr.md)

**status**: Final

**code**: 62238-1

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

**performer**: [PractitionerRole Doctor](PractitionerRole-PractRoleD12345.md)

**value**: 84 mg/ml/1, 73m2

### ReferenceRanges

| | |
| :--- | :--- |
| - | **Low** |
| * | 60 mg/ml/1, 73m2 |

**derivedFrom**: SIIA tuleb tervikdokumendi viide, kust analüüs pärit on?



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-egfr1",
  "meta" : {
    "profile" : [
      "https://fhir.ee/StructureDefinition/ee-tis-observation-egfr"
    ]
  },
  "language" : "et",
  "status" : "final",
  "code" : {
    "coding" : [
      {
        "code" : "62238-1"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "performer" : [
    {
      "reference" : "PractitionerRole/PractRoleD12345"
    }
  ],
  "valueQuantity" : {
    "value" : 84,
    "unit" : "mg/ml/1, 73m2"
  },
  "referenceRange" : [
    {
      "low" : {
        "value" : 60,
        "unit" : "mg/ml/1, 73m2"
      }
    }
  ],
  "derivedFrom" : [
    {
      "display" : "SIIA tuleb tervikdokumendi viide, kust analüüs pärit on?"
    }
  ]
}

```
