# MedicationStatementAlprazolam - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationStatementAlprazolam**

## Example MedicationStatement: MedicationStatementAlprazolam

Language: et

Profile: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)

> **ExtensionEETISSubstitution**
* substitutionAllowed: true
* substitutionAllowedReason: patsiendil on diagnoositud kaasuv psüühika- või käitumishäire

**ExtensionEETISTotalPrescribedAmount**: 30

**ExtensionEETISPrescriptionValidityTime**: 2023-11-07

> **ExtensionEETISMedicationRemainder**
* daysAvailable: 30
* daysDispensed: 10

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 50%
* reimbursementCondition: vajalikud tingimused bla bla
* reimbursementSpeciality: dermatoveneroloogia

**ExtensionEETISDispensationAuthorization**: Privaatne

**ExtensionEETISPrescriptionIntent**: order

> **ExtensionEETISVerification**
* verificationTime: 2023-11-09
* verificationAuthor: [PractitionerRole Doctor](PractitionerRole-PractRoleD12345.md)

**status**: Recorded

**category**: ühekordne, tavaretsept, 1-kordne

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = alprasolaam,Xanax XR; identifier = http://ravimiregister.ee/pakendid#1021857; doseForm = toimeainet prolongeeritult vabastav tablett; totalVolume = 30](Medication-alprazolam.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

**effective**: 2015-02-07 13:28:17-0500 --> (ongoing)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Paanikahäire |

**note**: By Practitioner/N98765 @2023-09-01

> 

patsient helistas ja soovis suuremat annust


> **dosage****timing**: Once per 24 hours

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 tablett(Details: ER_Ühikud annustamine codeTA = 'tablet(s)') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "MedicationStatementAlprazolam",
  "meta" : {
    "profile" : [
      "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
    ]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "substitutionAllowed",
          "valueBoolean" : true
        },
        {
          "url" : "substitutionAllowedReason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-asendamatuse-pohjus",
                "code" : "KP08",
                "display" : "patsiendil on diagnoositud kaasuv psüühika- või käitumishäire"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-substitution"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-total-prescribed-amount",
      "valueQuantity" : {
        "value" : 30
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-prescription-validity-time",
      "valueDateTime" : "2023-11-07"
    },
    {
      "extension" : [
        {
          "url" : "daysAvailable",
          "valueInteger" : 30
        },
        {
          "url" : "daysDispensed",
          "valueInteger" : 10
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-remainder"
    },
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "050",
                "display" : "50%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "50_1",
                "display" : "vajalikud tingimused bla bla"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/retsepti-volituse-liik",
            "code" : "private",
            "display" : "Privaatne"
          }
        ]
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-prescription-intent",
      "valueCode" : "order"
    },
    {
      "extension" : [
        {
          "url" : "verificationTime",
          "valueDateTime" : "2023-11-09"
        },
        {
          "url" : "verificationAuthor",
          "valueReference" : {
            "reference" : "PractitionerRole/PractRoleD12345"
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-verification"
    }
  ],
  "status" : "recorded",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ravikuuri-tyyp",
          "code" : "V",
          "display" : "Vajadusel"
        }
      ],
      "text" : "ühekordne"
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-liik",
          "code" : "1",
          "display" : "Tavaretsept"
        }
      ],
      "text" : "tavaretsept"
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-kordsus",
          "code" : "1",
          "display" : "1-kordne"
        }
      ],
      "text" : "1-kordne"
    }
  ],
  "medication" : {
    "reference" : {
      "reference" : "Medication/alprazolam"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "effectivePeriod" : {
    "start" : "2015-02-07T13:28:17-05:00"
  },
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/ValueSet/rhk10",
            "code" : "F41.0",
            "display" : "Paanikahäire"
          }
        ]
      }
    }
  ],
  "note" : [
    {
      "authorReference" : {
        "reference" : "Practitioner/N98765"
      },
      "time" : "2023-09-01",
      "text" : "patsient helistas ja soovis suuremat annust"
    }
  ],
  "dosage" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 24,
          "periodUnit" : "h"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "tablett",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "TA"
          }
        }
      ]
    }
  ]
}

```
