# MedicationStatement-metformin - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationStatement-metformin**

## Example MedicationStatement: MedicationStatement-metformin

Language: et

Profile: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)

> **ExtensionEETISSubstitution**
* substitutionAllowed: true
* substitutionAllowedReason: patsiendil on diagnoositud kaasuv psüühika- või käitumishäire

**ExtensionEETISTotalPrescribedAmount**: 100

**ExtensionEETISPrescriptionValidityTime**: 2023-11-07

> **ExtensionEETISMedicationRemainder**
* daysAvailable: 100
* daysDispensed: 30

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 90%
* reimbursementCondition: vajalikud tingimused bla bla
* reimbursementSpeciality: dermatoveneroloogia

**ExtensionEETISDispensationAuthorization**: Avalik

**ExtensionEETISPrescriptionIntent**: order

> **ExtensionEETISVerification**
* verificationTime: 2023-11-09
* verificationAuthor: [PractitionerRole Doctor](PractitionerRole-PractRoleD12345.md)

**status**: Recorded

**category**: Pidev, Tavaretsept, 3-kordne

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = metformiin; identifier = http://ravimiregister.ee/pakendid#123456; doseForm = tablett+õhukese polümeerikattega tablett; totalVolume = 120](Medication-metformin.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

**effective**: 2015-02-07 13:28:17-0500 --> (ongoing)

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Väärtoitumussuhkurtõbi |

**note**: By Practitioner/N98765 @2023-09-01

> 

patsient peaks iga päev veresuhkrut mõõtma


> **dosage****patientInstruction**: 1 tablett hommikul, 2 tabletti õhtul**timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 tablett(Details: ER_Ühikud annustamine codeTA = 'tablet(s)') |


> **dosage****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 tablett(Details: ER_Ühikud annustamine codeTA = 'tablet(s)') |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "MedicationStatement-metformin",
  "meta" : {
    "profile" : [
      "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
    ]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "substitutionAllowed",
          "valueBoolean" : true
        },
        {
          "url" : "substitutionAllowedReason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-asendamatuse-pohjus",
                "code" : "KP08",
                "display" : "patsiendil on diagnoositud kaasuv psüühika- või käitumishäire"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-substitution"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-total-prescribed-amount",
      "valueQuantity" : {
        "value" : 100
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-prescription-validity-time",
      "valueDateTime" : "2023-11-07"
    },
    {
      "extension" : [
        {
          "url" : "daysAvailable",
          "valueInteger" : 100
        },
        {
          "url" : "daysDispensed",
          "valueInteger" : 30
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-remainder"
    },
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "090",
                "display" : "90%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "90_1",
                "display" : "vajalikud tingimused bla bla"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/retsepti-volituse-liik",
            "code" : "public",
            "display" : "Avalik"
          }
        ]
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-prescription-intent",
      "valueCode" : "order"
    },
    {
      "extension" : [
        {
          "url" : "verificationTime",
          "valueDateTime" : "2023-11-09"
        },
        {
          "url" : "verificationAuthor",
          "valueReference" : {
            "reference" : "PractitionerRole/PractRoleD12345"
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-verification"
    }
  ],
  "status" : "recorded",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ravikuuri-tyyp",
          "code" : "P",
          "display" : "Pidev"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-liik",
          "code" : "1",
          "display" : "Tavaretsept"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-kordsus",
          "code" : "3",
          "display" : "3-kordne"
        }
      ]
    }
  ],
  "medication" : {
    "reference" : {
      "reference" : "Medication/metformin"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "effectivePeriod" : {
    "start" : "2015-02-07T13:28:17-05:00"
  },
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/rhk10",
            "code" : "E12",
            "display" : "Väärtoitumussuhkurtõbi"
          }
        ]
      }
    }
  ],
  "note" : [
    {
      "authorReference" : {
        "reference" : "Practitioner/N98765"
      },
      "time" : "2023-09-01",
      "text" : "patsient peaks iga päev veresuhkrut mõõtma"
    }
  ],
  "dosage" : [
    {
      "patientInstruction" : "1 tablett hommikul, 2 tabletti õhtul",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["09:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "tablett",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "TA"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["21:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "tablett",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "TA"
          }
        }
      ]
    }
  ]
}

```
