# prescription-metformin - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **prescription-metformin**

## Example MedicationRequest: prescription-metformin

Language: et

Profile: [EETISPrescription](StructureDefinition-ee-tis-prescription.md)

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 90%
* reimbursementCondition: vajalikud tingimused bla bla
* reimbursementSpeciality: dermatoveneroloogia

**ExtensionEETISDispensationAuthorization**: Avalik

**identifier**: `https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept`/1018862058

**status**: Active

**statusChanged**: 2014-06-10

**intent**: Order

**category**: Tavaretsept, 3-kordne

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = metformiin; identifier = http://ravimiregister.ee/pakendid#123456; doseForm = tablett+õhukese polümeerikattega tablett; totalVolume = 120](Medication-metformin.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

**authoredOn**: 2023-11-07

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Väärtoitumussuhkurtõbi |

**courseOfTherapyType**: Pidev

> **dosageInstruction****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 tablett(Details: ER_Ühikud annustamine codeTA = 'tablet(s)') |


> **dosageInstruction****timing**: Once per 1 day

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 2 tablett(Details: ER_Ühikud annustamine codeTA = 'tablet(s)') |


### DispenseRequests

| | |
| :--- | :--- |
| - | **ValidityPeriod** |
| * | 2023-11-07 --> 2024-05-07 |

### Substitutions

| | | |
| :--- | :--- | :--- |
| - | **Allowed[x]** | **Reason** |
| * | false | tegemist on bioloogilise ravimiga |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "prescription-metformin",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "090",
                "display" : "90%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "90_1",
                "display" : "vajalikud tingimused bla bla"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/retsepti-volituse-liik",
            "code" : "public",
            "display" : "Avalik"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept",
      "value" : "1018862058"
    }
  ],
  "status" : "active",
  "statusChanged" : "2014-06-10",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-liik",
          "code" : "1",
          "display" : "Tavaretsept"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-kordsus",
          "code" : "3",
          "display" : "3-kordne"
        }
      ]
    }
  ],
  "medication" : {
    "reference" : {
      "reference" : "Medication/metformin"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "authoredOn" : "2023-11-07",
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/rhk10",
            "code" : "E12",
            "display" : "Väärtoitumussuhkurtõbi"
          }
        ]
      }
    }
  ],
  "courseOfTherapyType" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/ravikuuri-tyyp",
        "code" : "P",
        "display" : "Pidev"
      }
    ]
  },
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["09:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "tablett",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "TA"
          }
        }
      ]
    },
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d",
          "timeOfDay" : ["21:00:00"]
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 2,
            "unit" : "tablett",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "TA"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2023-11-07",
      "end" : "2024-05-07"
    }
  },
  "substitution" : {
    "allowedBoolean" : false,
    "reason" : {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ravimi-asendamatuse-pohjus",
          "code" : "KP01",
          "display" : "tegemist on bioloogilise ravimiga"
        }
      ]
    }
  }
}

```
