# prescription-alprazolam - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **prescription-alprazolam**

## Example MedicationRequest: prescription-alprazolam

Language: et

Profile: [EETISPrescription](StructureDefinition-ee-tis-prescription.md)

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 50%
* reimbursementCondition: vajalikud tingimused bla bla
* reimbursementSpeciality: dermatoveneroloogia

**ExtensionEETISDispensationAuthorization**: Avalik

**identifier**: `https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept`/1018862058

**status**: Active

**statusChanged**: 2014-06-10

**intent**: Order

**category**: Tavaretsept, 1-kordne

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = alprasolaam,Xanax XR; identifier = http://ravimiregister.ee/pakendid#1021857; doseForm = toimeainet prolongeeritult vabastav tablett; totalVolume = 30](Medication-alprazolam.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

**authoredOn**: 2023-11-07

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Paanikahäire |

> **dosageInstruction****timing**: Once per 24 hours

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 tablett(Details: ER_Ühikud annustamine codeTA = 'tablet(s)') |


### DispenseRequests

| | |
| :--- | :--- |
| - | **ValidityPeriod** |
| * | 2023-11-07 --> 2023-12-07 |

### Substitutions

| | | |
| :--- | :--- | :--- |
| - | **Allowed[x]** | **Reason** |
| * | true | patsiendil on diagnoositud kaasuv psüühika- või käitumishäire |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "prescription-alprazolam",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "050",
                "display" : "50%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "50_1",
                "display" : "vajalikud tingimused bla bla"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/retsepti-volituse-liik",
            "code" : "public",
            "display" : "Avalik"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept",
      "value" : "1018862058"
    }
  ],
  "status" : "active",
  "statusChanged" : "2014-06-10",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-liik",
          "code" : "1",
          "display" : "Tavaretsept"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-kordsus",
          "code" : "1",
          "display" : "1-kordne"
        }
      ]
    }
  ],
  "medication" : {
    "reference" : {
      "reference" : "Medication/alprazolam"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "authoredOn" : "2023-11-07",
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/rhk10",
            "code" : "F41.0",
            "display" : "Paanikahäire"
          }
        ]
      }
    }
  ],
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 24,
          "periodUnit" : "h"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "tablett",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "TA"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2023-11-07",
      "end" : "2023-12-07"
    }
  },
  "substitution" : {
    "allowedBoolean" : true,
    "reason" : {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ravimi-asendamatuse-pohjus",
          "code" : "KP08",
          "display" : "patsiendil on diagnoositud kaasuv psüühika- või käitumishäire"
        }
      ]
    }
  }
}

```
