# dispensation-metformin - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **dispensation-metformin**

## Example MedicationDispense: dispensation-metformin

Language: et

Profile: [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 90%
* reimbursementCondition: vajalikud tingimused sellise soodustuse saamiseks
* reimbursementSpeciality: dermatoveneroloogia

**ExtensionEETISBuyerEPC**: 42002230000

> **ExtensionEETISMedicationRemainder**
* daysAvailable: 200
* daysDispensed: 100

**status**: Completed

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = METFORAL 500MG; identifier = http://ravimiregister.ee/pakendid#1064719](Medication-metformin-dispensed.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [PractitionerRole pharmacist](PractitionerRole-pharmacistKristiina.md) |

**authorizingPrescription**: [MedicationRequest: extension = ,Avalik; identifier = https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept#1018862058; status = active; statusChanged = 2014-06-10; intent = order; category = Tavaretsept,3-kordne; authoredOn = 2023-11-07; courseOfTherapyType = Pidev](MedicationRequest-prescription-metformin.md)

**quantity**: 100

**daysSupply**: 33.3

**whenHandedOver**: 2023-11-07

**note**: 

> 

ravim väljastatud ainult osaliselt, sest puudus õige suurusega pakend




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "dispensation-metformin",
  "meta" : {
    "profile" : [
      "https://fhir.ee/StructureDefinition/ee-tis-prescription-dispense"
    ]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "090",
                "display" : "90%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "90_1",
                "display" : "vajalikud tingimused sellise soodustuse saamiseks"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-buyer-epc",
      "valueString" : "42002230000"
    },
    {
      "extension" : [
        {
          "url" : "daysAvailable",
          "valueInteger" : 200
        },
        {
          "url" : "daysDispensed",
          "valueInteger" : 100
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-remainder"
    }
  ],
  "status" : "completed",
  "medication" : {
    "reference" : {
      "reference" : "Medication/metformin-dispensed"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "PractitionerRole/pharmacistKristiina"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/prescription-metformin"
    }
  ],
  "quantity" : {
    "value" : 100
  },
  "daysSupply" : {
    "value" : 33.3
  },
  "whenHandedOver" : "2023-11-07",
  "note" : [
    {
      "text" : "ravim väljastatud ainult osaliselt, sest puudus õige suurusega pakend"
    }
  ]
}

```
