# dispensation-alprazolam - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **dispensation-alprazolam**

## Example MedicationDispense: dispensation-alprazolam

Language: et

Profile: [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 0%
* reimbursementCondition: vajalikud tingimused sellise soodustuse saamiseks
* reimbursementSpeciality: dermatoveneroloogia

**status**: Completed

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = Xanax XR; identifier = http://ravimiregister.ee/pakendid#1021857](Medication-alprazolam-dispensed.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [PractitionerRole pharmacist](PractitionerRole-pharmacistKristiina.md) |

**authorizingPrescription**: [MedicationRequest: extension = ,Avalik; identifier = https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept#1018862058; status = active; statusChanged = 2014-06-10; intent = order; category = Tavaretsept,1-kordne; authoredOn = 2023-11-07](MedicationRequest-prescription-alprazolam.md)

**quantity**: 30

**daysSupply**: 30

**whenHandedOver**: 2023-11-07

**note**: 

> 

ei ole võimalik väljastada arsti kirjutatud soodustusega




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "dispensation-alprazolam",
  "meta" : {
    "profile" : [
      "https://fhir.ee/StructureDefinition/ee-tis-prescription-dispense"
    ]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "000",
                "display" : "0%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "90_1",
                "display" : "vajalikud tingimused sellise soodustuse saamiseks"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    }
  ],
  "status" : "completed",
  "medication" : {
    "reference" : {
      "reference" : "Medication/alprazolam-dispensed"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "PractitionerRole/pharmacistKristiina"
      }
    }
  ],
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/prescription-alprazolam"
    }
  ],
  "quantity" : {
    "value" : 30
  },
  "daysSupply" : {
    "value" : 30
  },
  "whenHandedOver" : "2023-11-07",
  "note" : [
    {
      "text" : "ei ole võimalik väljastada arsti kirjutatud soodustusega"
    }
  ]
}

```
