# metformin - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **metformin**

## Example Medication: metformin

Language: et

Profile: [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)

**ExtensionEETISMedicinalProductClassification**: metformiin

**identifier**: `http://ravimiregister.ee/pakendid`/123456

**doseForm**: tablett+õhukese polümeerikattega tablett

**totalVolume**: 120

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | metformiin |

**isActive**: true**strength**: 500(unit MG from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeMG = 'milligram(s)')/1(unit TABL from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeTABL = 'tablet(s)')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "metformin",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
  },
  "language" : "et",
  "extension" : [
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/atc-ee",
            "code" : "A10BA02",
            "display" : "metformiin"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "system" : "http://ravimiregister.ee/pakendid",
      "value" : "123456"
    }
  ],
  "doseForm" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/ravimvormid",
        "code" : "1518",
        "display" : "tablett+õhukese polümeerikattega tablett"
      }
    ]
  },
  "totalVolume" : {
    "value" : 120
  },
  "ingredient" : [
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "https://fhir.ee/CodeSystem/toimeained",
              "code" : "11354",
              "display" : "metformiin"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "numerator" : {
          "value" : 500,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "MG"
        },
        "denominator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "TABL"
        }
      }
    }
  ]
}

```
