# dexamethason - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **dexamethason**

## Example Medication: dexamethason

Language: et

Profile: [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)

**ExtensionEETISMedicinalProductClassification**: deksametasoon

**ExtensionEETISMedicinalProductName**: Nodexon

**identifier**: `http://ravimiregister.ee/pakendid`/123456

**doseForm**: tablett

**totalVolume**: 20

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | deksametasoon |

**isActive**: true**strength**: 4(unit MG from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeMG = 'milligram(s)')/1(unit TABL from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeTABL = 'tablet(s)')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "dexamethason",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
  },
  "language" : "et",
  "extension" : [
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/atc-ee",
            "code" : "H02AB02",
            "display" : "deksametasoon"
          }
        ]
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name",
      "valueString" : "Nodexon"
    }
  ],
  "identifier" : [
    {
      "system" : "http://ravimiregister.ee/pakendid",
      "value" : "123456"
    }
  ],
  "doseForm" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/ravimvormid",
        "code" : "738",
        "display" : "tablett"
      }
    ]
  },
  "totalVolume" : {
    "value" : 20
  },
  "ingredient" : [
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "https://fhir.ee/CodeSystem/toimeained",
              "code" : "8510",
              "display" : "deksametasoon"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "numerator" : {
          "value" : 4,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "MG"
        },
        "denominator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "TABL"
        }
      }
    }
  ]
}

```
