# alprazolam - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **alprazolam**

## Example Medication: alprazolam

Language: et

Profile: [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)

**ExtensionEETISMedicinalProductClassification**: alprasolaam

**ExtensionEETISMedicinalProductName**: Xanax XR

**identifier**: `http://ravimiregister.ee/pakendid`/1021857

**doseForm**: toimeainet prolongeeritult vabastav tablett

**totalVolume**: 30

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | alprasolaam |

**isActive**: true**strength**: 1(unit MG from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeMG = 'milligram(s)')/1(unit TABL from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeTABL = 'tablet(s)')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "alprazolam",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
  },
  "language" : "et",
  "extension" : [
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/atc-ee",
            "code" : "N05BA12",
            "display" : "alprasolaam"
          }
        ]
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name",
      "valueString" : "Xanax XR"
    }
  ],
  "identifier" : [
    {
      "system" : "http://ravimiregister.ee/pakendid",
      "value" : "1021857"
    }
  ],
  "doseForm" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/ravimvormid",
        "code" : "1224",
        "display" : "toimeainet prolongeeritult vabastav tablett"
      }
    ]
  },
  "totalVolume" : {
    "value" : 30
  },
  "ingredient" : [
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "https://fhir.ee/CodeSystem/toimeained",
              "code" : "11707",
              "display" : "alprasolaam"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "numerator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "MG"
        },
        "denominator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "TABL"
        }
      }
    }
  ]
}

```
