# adrenalin - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **adrenalin**

## Example Medication: adrenalin

Language: et

Profile: [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)

**ExtensionEETISMedicinalProductClassification**: epinefriin

**ExtensionEETISSizeOfItem**: 1(unit ML from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeML = 'milliliter(s)')

**ExtensionEETISMedicinalProductName**: Adrenaliin

**identifier**: `http://ravimiregister.ee/pakendid`/123456

**doseForm**: süstelahus

**totalVolume**: 5

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | epinefriin |

**isActive**: true**strength**: 1(unit MG from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeMG = 'milligram(s)')/1(unit ML from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeML = 'milliliter(s)')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "adrenalin",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
  },
  "language" : "et",
  "extension" : [
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/atc-ee",
            "code" : "C01CA24",
            "display" : "epinefriin"
          }
        ]
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-size-of-item",
      "valueQuantity" : {
        "value" : 1,
        "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
        "code" : "ML"
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name",
      "valueString" : "Adrenaliin"
    }
  ],
  "identifier" : [
    {
      "system" : "http://ravimiregister.ee/pakendid",
      "value" : "123456"
    }
  ],
  "doseForm" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/ravimvormid",
        "code" : "739",
        "display" : "süstelahus"
      }
    ]
  },
  "totalVolume" : {
    "value" : 5
  },
  "ingredient" : [
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "https://fhir.ee/CodeSystem/toimeained",
              "code" : "8554",
              "display" : "epinefriin"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "numerator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "MG"
        },
        "denominator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "ML"
        }
      }
    }
  ]
}

```
