# comment-renal-failure - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **comment-renal-failure**

## Example Communication: comment-renal-failure

Language: et

Profile: [EETISCommunication](StructureDefinition-ee-tis-communication.md)

**identifier**: 080808

**status**: Completed

**category**: D1. siia tuleb hoiatus neerufunktsiooni langusest

**about**: [MedicationStatement: extension = ,30,2023-11-07,,,Privaatne,order,; status = recorded; category = Vajadusel,Tavaretsept,1-kordne; effective[x] = 2015-02-07 13:28:17-0500 --> (ongoing); note = patsient helistas ja soovis suuremat annust](MedicationStatement-MedicationStatementAlprazolam.md)

**sent**: 2025-03-12

**sender**: [PractitionerRole Doctor](PractitionerRole-PractRoleD12345.md)

### Reasons

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = alprasolaam,Xanax XR; identifier = http://ravimiregister.ee/pakendid#1021857; doseForm = toimeainet prolongeeritult vabastav tablett; totalVolume = 30](Medication-alprazolam.md) |

### Payloads

| | |
| :--- | :--- |
| - | **Content[x]** |
| * | annuse vähendamsie põhjendus seoses neerufunktsiooni langusega |



## Resource Content

```json
{
  "resourceType" : "Communication",
  "id" : "comment-renal-failure",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-communication"]
  },
  "language" : "et",
  "identifier" : [
    {
      "value" : "080808"
    }
  ],
  "status" : "completed",
  "category" : [
    {
      "coding" : [
        {
          "code" : "alert"
        }
      ],
      "text" : "D1. siia tuleb hoiatus neerufunktsiooni langusest"
    }
  ],
  "about" : [
    {
      "reference" : "MedicationStatement/MedicationStatementAlprazolam"
    }
  ],
  "sent" : "2025-03-12",
  "sender" : {
    "reference" : "PractitionerRole/PractRoleD12345"
  },
  "reason" : [
    {
      "reference" : {
        "reference" : "Medication/alprazolam"
      }
    }
  ],
  "payload" : [
    {
      "contentCodeableConcept" : {
        "text" : "annuse vähendamsie põhjendus seoses neerufunktsiooni langusega"
      }
    }
  ]
}

```
