# renal-function-failure - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **renal-function-failure**

## Example ClinicalUseDefinition: renal-function-failure



## Resource Content

```json
{
  "resourceType" : "ClinicalUseDefinition",
  "id" : "renal-function-failure",
  "meta" : {
    "profile" : [
      "https://fhir.ee/StructureDefinition/ee-tis-renal-failure-ds"
    ]
  },
  "language" : "et",
  "contained" : [
    {
      "resourceType" : "Medication",
      "id" : "metformin",
      "meta" : {
        "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
      },
      "language" : "et",
      "extension" : [
        {
          "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/atc-ee",
                "code" : "A10BA02",
                "display" : "metformiin"
              }
            ]
          }
        }
      ],
      "identifier" : [
        {
          "system" : "http://ravimiregister.ee/pakendid",
          "value" : "123456"
        }
      ],
      "doseForm" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/ravimvormid",
            "code" : "1518",
            "display" : "tablett+õhukese polümeerikattega tablett"
          }
        ]
      },
      "totalVolume" : {
        "value" : 120
      },
      "ingredient" : [
        {
          "item" : {
            "concept" : {
              "coding" : [
                {
                  "system" : "https://fhir.ee/CodeSystem/toimeained",
                  "code" : "11354",
                  "display" : "metformiin"
                }
              ]
            }
          },
          "isActive" : true,
          "strengthRatio" : {
            "numerator" : {
              "value" : 500,
              "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
              "code" : "MG"
            },
            "denominator" : {
              "value" : 1,
              "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
              "code" : "TABL"
            }
          }
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-affected-medication-statements",
      "valueReference" : {
        "reference" : "MedicationStatement/MedicationStatement-metformin"
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-additional-information-link",
      "valueString" : "www.synbase.ee/metformin-neerufunktsioon"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-nephrotoxic",
      "valueBoolean" : false
    },
    {
      "extension" : [
        {
          "url" : "dosageIntervalMin",
          "valueQuantity" : {
            "value" : 6
          }
        },
        {
          "url" : "dosageIntervalMax",
          "valueQuantity" : {
            "value" : 12
          }
        },
        {
          "url" : "recommendation",
          "valueString" : "Siin on soovitused"
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-dosage-modification"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-related-observation-or-condition",
      "valueReference" : {
        "reference" : "Observation/observation-egfr1"
      }
    }
  ],
  "type" : "undesirable-effect",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/drug-form-group",
          "code" : "2",
          "display" : "süsteemne"
        }
      ],
      "text" : "Kirjeldus siia text alla, kui on veel vaja midagi lisada"
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/failure-degree",
          "code" : "1",
          "display" : "GFR 30-59 ml/min (mõõdukas neerupuudulikkus)"
        }
      ],
      "text" : "Kirjeldus siia text alla, kui on veel vaja midagi lisada"
    },
    {
      "text" : "Kuna vosoritiidi ohutust ja efektiivsust neerukahjustuse korral ei ole hinnatud [(1)],[(2)], ei saa tõenduspõhiseid soovitusi anda. Siiski, tuginedes eliminatsioonimehhanismile, ei mõjuta neerupuudulikkus ilmselt vosoritiidi farmakokineetikat. Vosoritiid on modifitseeritud C-tüüpi natriureetiline peptiid. Vosoritiidi metabolism toimub eeldatavasti kataboolsete radade kaudu ja laguneb väikesteks peptiidideks ja aminohapeteks [(1)], [(2)]."
    }
  ],
  "subject" : [
    {
      "reference" : "#metformin"
    }
  ],
  "status" : {
    "coding" : [
      {
        "code" : "active"
      }
    ]
  },
  "undesirableEffect" : {
    "classification" : {
      "coding" : [
        {
          "system" : "https://fhir.ee/synbase-warning-classification",
          "code" : "C",
          "display" : "Annust või annustamise vahemikku tuleb kohandada"
        }
      ],
      "text" : "Kui on veel vaja midagi lisada"
    }
  }
}

```
