/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.stereo.Stereostyles;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatures;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;

public class StyleSignatureBasic
implements StyleSignature {
    public static final String STAR = "*";
    private final Set<String> names = new LinkedHashSet<String>();
    private final boolean withDot;

    public StyleSignatureBasic(String s) {
        if (s.contains(STAR) || s.contains("&") || s.contains("-")) {
            throw new IllegalArgumentException();
        }
        this.withDot = s.contains(".");
        this.names.add(this.clean(s));
    }

    public static StyleSignatureBasic empty() {
        return new StyleSignatureBasic(false);
    }

    private StyleSignatureBasic(boolean withDot) {
        this.withDot = withDot;
    }

    private StyleSignatureBasic(boolean withDot, Collection<String> copy) {
        this.names.addAll(copy);
        this.withDot = withDot;
    }

    public StyleSignatureBasic addClickable(Url url) {
        if (url == null) {
            return this;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.names);
        result.add(SName.clickable.name());
        return new StyleSignatureBasic(this.withDot, result);
    }

    public StyleSignatureBasic add(String s) {
        if (s == null) {
            return this;
        }
        if (s.contains("&")) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.names);
        result.add(this.clean(s));
        return new StyleSignatureBasic(this.withDot || s.contains("."), result);
    }

    public StyleSignatureBasic addS(Stereotype stereo) {
        if (stereo == null) {
            return this;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.names);
        boolean withDotLocal = this.withDot;
        for (String s : stereo.getLabels(Guillemet.NONE)) {
            if (s.contains("&")) {
                throw new IllegalArgumentException();
            }
            result.add("%" + this.clean(s));
            withDotLocal = withDotLocal || s.contains(".");
        }
        return new StyleSignatureBasic(withDotLocal, result);
    }

    public StyleSignatureBasic add(SName name) {
        return this.add(name.name().toLowerCase().replace("_", ""));
    }

    public StyleSignatureBasic addStar() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.names);
        result.add(STAR);
        return new StyleSignatureBasic(this.withDot, result);
    }

    public boolean isStarred() {
        return this.names.contains(STAR);
    }

    public boolean equals(Object arg) {
        StyleSignatureBasic other = (StyleSignatureBasic)arg;
        return this.names.equals(other.names);
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String n : this.names) {
            if (result.length() > 0) {
                result.append('.');
            }
            result.append(n);
        }
        return result.toString() + " " + this.withDot;
    }

    public boolean matchAll(StyleSignatureBasic other) {
        boolean namesContainsStar = this.names.contains(STAR);
        if (other.isStarred() && !namesContainsStar) {
            return false;
        }
        int depthInNames = StyleSignatureBasic.depthFromTokens(other.names);
        for (String token : this.names) {
            if (token.equals(STAR) || !(namesContainsStar && depthInNames != -1 && StyleSignatureBasic.depthFromToken(token) != -1 ? depthInNames < StyleSignatureBasic.depthFromToken(token) : !other.names.contains(token))) continue;
            return false;
        }
        return true;
    }

    private static int depthFromToken(String token) {
        if (token.startsWith("depth(")) {
            return Integer.parseInt(token.substring("depth(".length(), token.length() - 1));
        }
        return -1;
    }

    private static int depthFromTokens(Collection<String> tokens) {
        for (String token : tokens) {
            int depth = StyleSignatureBasic.depthFromToken(token);
            if (depth == -1) continue;
            return depth;
        }
        return -1;
    }

    public final Set<String> getNames() {
        return Collections.unmodifiableSet(this.names);
    }

    public static StyleSignatureBasic of(SName ... names) {
        ArrayList<String> result = new ArrayList<String>();
        for (SName name : names) {
            result.add(name.name().toLowerCase().replace("_", ""));
        }
        return new StyleSignatureBasic(false, result);
    }

    public StyleSignature forStereotypeItself(Stereotype stereotype) {
        if (stereotype == null || stereotype.getStyleNames().size() == 0) {
            return this;
        }
        StyleSignatures result = new StyleSignatures();
        for (String name : stereotype.getStyleNames()) {
            ArrayList<String> tmp = new ArrayList<String>(this.names);
            tmp.add(SName.stereotype.name().toLowerCase().replace("_", ""));
            tmp.add(this.clean(name));
            result.add(new StyleSignatureBasic(false, tmp));
        }
        return result;
    }

    @Override
    public StyleSignature withTOBECHANGED(Stereotype stereotype) {
        if (stereotype == null || stereotype.getStyleNames().size() == 0) {
            return this;
        }
        StyleSignatures result = new StyleSignatures();
        for (String name : stereotype.getStyleNames()) {
            ArrayList<String> tmp = new ArrayList<String>(this.names);
            tmp.add(this.clean(name));
            result.add(new StyleSignatureBasic(true, tmp));
        }
        return result;
    }

    @Override
    public StyleSignature with(Stereostyles stereostyles) {
        if (stereostyles.isEmpty()) {
            return this;
        }
        ArrayList<String> result = new ArrayList<String>(this.names);
        for (String name : stereostyles.getStyleNames()) {
            result.add("%" + this.clean(name));
        }
        return new StyleSignatureBasic(true, result);
    }

    private String clean(String name) {
        if (name.startsWith(".")) {
            name = "%" + name;
        }
        return name.toLowerCase().replace("_", "").replace(".", "");
    }

    public StyleSignatureBasic mergeWith(List<Style> others) {
        ArrayList<String> copy = new ArrayList<String>(this.names);
        for (Style other : others) {
            for (String s : other.getSignature().getNames()) {
                copy.add(s);
            }
        }
        return new StyleSignatureBasic(this.withDot, copy);
    }

    public StyleSignatureBasic mergeWith(StyleSignatureBasic other) {
        ArrayList<String> copy = new ArrayList<String>(this.names);
        copy.addAll(other.names);
        return new StyleSignatureBasic(this.withDot || other.withDot, copy);
    }

    @Override
    public Style getMergedStyle(StyleBuilder styleBuilder) {
        if (styleBuilder == null) {
            return null;
        }
        return styleBuilder.getMergedStyle(this);
    }

    public boolean match(Stereotype stereotype) {
        for (String s : stereotype.getMultipleLabels()) {
            if (!this.names.contains(this.clean(s))) continue;
            return true;
        }
        return false;
    }

    public final boolean isWithDot() {
        return this.withDot;
    }

    public static StyleSignatureBasic activity() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity);
    }

    public static StyleSignatureBasic activityDiamond() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.diamond);
    }

    public static StyleSignatureBasic activityArrow() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.activityDiagram, SName.activity, SName.arrow);
    }
}

