/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandNoteBottom
extends CommandMultilines2<GanttDiagram> {
    public CommandNoteBottom() {
        super(CommandNoteBottom.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNoteBottom.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(note)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("POSITION", "(bottom)"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREO"), RegexLeaf.end());
    }

    @Override
    public String getPatternEnd() {
        return "^end[%s]*note$";
    }

    @Override
    protected CommandExecutionResult executeNow(GanttDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        Display strings = (lines = lines.removeEmptyColumns()).toDisplay();
        if (strings.size() == 0) {
            return CommandExecutionResult.error("No note defined");
        }
        String stereotypeString = line0.get("STEREO", 0);
        Stereotype stereotype = null;
        if (stereotypeString != null) {
            stereotype = Stereotype.build(stereotypeString);
        }
        return diagram.addNote(strings, stereotype);
    }
}

