# Home - Tanzania FHIR Facade Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:http://speedykom.org/tz-fhir-facade/ImplementationGuide/tz.fhir.facade.ig | *Version*:0.1.0 |
| Active as of 2025-11-20 | *Computable Name*:TzFhirFacadeIG |

 This Implementation Guide describes the **Tanzania FHIR Facade**, a standards-based interoperability layer designed to integrate legacy health systems with a national, modern FHIR R5 ecosystem. 

> **This guide is under active development.**The content represents a continuous build based on the current GitHub branch and may change frequently.

### Overview

 The Tanzania FHIR Facade provides: 

* FHIR R5 profiles for PII, clinical, and administrative workflows
* Logical Models describing legacy data structures (e.g., CardDetails, ViralLoad, Encounters)
* StructureMaps supporting: 
* Legacy → FHIR R5 transformation
* FHIR R5 → Legacy system transformation
 
* Terminology support via ConceptMaps and CodeSystems
* Reference examples for mediators, mapping workflows, and validation pipelines

 The facade is designed to be used with: 

* OpenHIM mediators
* Matchbox Mapping Engine
* A dedicated IG validation server
* Separation of PII and Clinical data using two HAPI FHIR R5 servers

### Content

 This publication includes the full set of specifications, profiles, logical models, maps, examples, value sets, and code systems included in the Tanzania FHIR Facade. 

 The navigation menu at the top provides quick access to the sections of this guide. You may also use the [Table of Contents](toc.md) which lists all pages. 

### Download

You can download:

* [The entire guide](full-ig.zip)
* Definition resources in [JSON](definitions.json.zip), [XML](definitions.xml.zip), [Turtle](definitions.ttl.zip), or [CSV](csvs.zip) 
* Example resources in [JSON](examples.json.zip), [XML](examples.xml.zip), [Turtle](examples.ttl.zip) 
* [R5 NPM Package](package.tgz)

 The source code for this IG is available on [GitHub](https://github.com/Speedykom/tz-fhir-facade-ig). 

### Cross Version Analysis

### Dependency Table



### Globals Table

*There are no Global profiles defined*

### IP Statements

No use of external IP (other than from the FHIR specification)

### Intellectual Property Considerations

 This IG may reference content from external terminologies such as SNOMED CT, LOINC, and UCUM. These may require separate licensing. Implementers are responsible for ensuring compliance with all terminology licensing conditions. 

### Disclaimer

 This is a draft specification provided without warranty. The continuous build may contain incomplete or experimental content. Use at your own discretion. 

