# About and Download - SHIFT SLS Reference Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **About and Download**

## About and Download

You can download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), [ttl](definitions.ttl.zip), or [csv](csvs.zip) format, or
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on [SHIFT Task Force Github Repo](https://github.com/SHIFT-Task-Force).

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (SHIFT-Task-Force.sls-ri.r4)](package.r4.tgz) and [R4B (SHIFT-Task-Force.sls-ri.r4b)](package.r4b.tgz) are available.

#### Dependency Table



#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [BehavioralHealthMultiTopic](ValueSet-behavioral-health-multi-topic.md), [MentalHealthConditions](ValueSet-mental-health-conditions.md) and [SubstanceAbuse](ValueSet-substance-abuse.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [UsageContextType](http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html): [BehavioralHealthMultiTopic](ValueSet-behavioral-health-multi-topic.md), [MentalHealthConditions](ValueSet-mental-health-conditions.md), [SlsValueSet](StructureDefinition-SlsValueSet.md) and [SubstanceAbuse](ValueSet-substance-abuse.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [BehavioralHealthMultiTopic](ValueSet-behavioral-health-multi-topic.md), [MentalHealthConditions](ValueSet-mental-health-conditions.md) and [SubstanceAbuse](ValueSet-substance-abuse.md)


