# Substance Abuse Conditions ValueSet - SHIFT SLS Reference Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Substance Abuse Conditions ValueSet**

## ValueSet: Substance Abuse Conditions ValueSet 

| | |
| :--- | :--- |
| *Official URL*:http://example.org/fhir/ValueSet/substance-abuse | *Version*:0.1.0 |
| Active as of 2024-01-01 | *Computable Name*:SubstanceAbuse |
| **Usage:**Clinical Focus: substance abuse information sensitivity | |

 
ValueSet for substance abuse conditions used in the SLS RI. This ValueSet includes codes for substance abuse conditions that are relevant to the SLS use cases. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

No formal definition provided for this value set

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "substance-abuse",
  "meta" : {
    "profile" : [
      "http://SHIFT-Task-Force.github.io/sls-ri/StructureDefinition/SlsValueSet"
    ]
  },
  "url" : "http://example.org/fhir/ValueSet/substance-abuse",
  "version" : "0.1.0",
  "name" : "SubstanceAbuse",
  "title" : "Substance Abuse Conditions",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-01T00:00:00Z",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "ValueSet for substance abuse conditions used in the SLS RI. This ValueSet includes codes for substance abuse conditions that are relevant to the SLS use cases.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "ETH"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "expansion" : {
    "timestamp" : "2024-01-01T00:00:00Z",
    "contains" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "191816009",
        "display" : "Alcohol abuse"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "191820008",
        "display" : "Drug abuse"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "66214007",
        "display" : "Substance abuse (disorder)"
      }
    ]
  }
}

```
