# Artifacts Summary - SHIFT SLS Reference Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [SLS FHIR Server Capability Statement](CapabilityStatement-fhir-sls-server.md) | Capability Statement for the SLS FHIR Server |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [SLS Load ValueSets Operation Definition](OperationDefinition-sls-load-valuesets.md) | Operation Definition for loading SLS ValueSets. This is used to populate the server with the necessary ValueSets for SLS. |
| [SLS Tag Data Operation Definition](OperationDefinition-sls-tag.md) | Operation Definition for applying security labels to the data passed in according to the loaded ValueSets. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [SLS ValueSet Profile](StructureDefinition-SlsValueSet.md) | Profile for ValueSets used in the SLS RI* [Shared ValueSets](https://fhir.hl7.org/fhir/shareablevalueset.html) require `experimental`, `url`, `title`, `description`, and `status`.
* `title` and `description` are encouraged to keep track of the purpose and use of the ValueSet as it is not always clear from the content of the ValueSet itself.
* `compose.inactive` tends to need to be `true` as the ValueSet is covering historic data that may have been coded long ago when the now inactive codes were allowed.
* `useContext` of focus is the tag value applied to data that matches a code in this ValueSet 
* `display` values are discouraged as they simply add size to the tagged output.
* in R5/R6 the `topic` value can be used.
 
* `date` is the date the ValueSet was created or last updated. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last update of the ValueSet.
* `expansion.timestamp` is the date the ValueSet was expanded. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last expansion of the ValueSet.
* `expansion` SHOULD provide expanded ValueSet as that give the definitive list of codes and a timestamp for when the expansion was performed. This allows the SLS RI to determine if the data being inspected matches any of the codes in the ValueSet without having to perform an expansion itself. 
* The RI can expand the ValueSet itself if the expansion is not provided, but this expansion limits the timestamp to now, thus forcing inspection of all data even when the actual valueSet has not changed.
* The expansion is done by an external service which is then a dependency. The SLS RI uses tx.fhir.org terminology service.
 
 |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Behavioral Health - Multiple Topics ValueSet](ValueSet-behavioral-health-multi-topic.md) | ValueSet for behavioral health conditions that span multiple topics used in the SLS RI. This ValueSet includes codes for behavioral health conditions that are relevant to the SLS use cases and may span multiple topics such as mental health, substance abuse, and psychotherapy notes. |
| [Mental Health Conditions ValueSet](ValueSet-mental-health-conditions.md) | ValueSet for mental health conditions used in the SLS RI. This ValueSet includes codes for mental health conditions that are relevant to the SLS use cases. |
| [Substance Abuse Conditions ValueSet](ValueSet-substance-abuse.md) | ValueSet for substance abuse conditions used in the SLS RI. This ValueSet includes codes for substance abuse conditions that are relevant to the SLS use cases. |

