# SLS ValueSet Profile - SHIFT SLS Reference Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLS ValueSet Profile**

## Resource Profile: SLS ValueSet Profile 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/sls-ri/StructureDefinition/SlsValueSet | *Version*:0.1.0 |
| Active as of 2026-02-06 | *Computable Name*:SlsValueSet |

 
Profile for ValueSets used in the SLS RI 
* [Shared ValueSets](https://fhir.hl7.org/fhir/shareablevalueset.html) require `experimental`, `url`, `title`, `description`, and `status`.
* `title` and `description` are encouraged to keep track of the purpose and use of the ValueSet as it is not always clear from the content of the ValueSet itself.
* `compose.inactive` tends to need to be `true` as the ValueSet is covering historic data that may have been coded long ago when the now inactive codes were allowed.
* `useContext` of focus is the tag value applied to data that matches a code in this ValueSet 
* `display` values are discouraged as they simply add size to the tagged output.
* in R5/R6 the `topic` value can be used.
 
* `date` is the date the ValueSet was created or last updated. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last update of the ValueSet.
* `expansion.timestamp` is the date the ValueSet was expanded. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last expansion of the ValueSet.
* `expansion` SHOULD provide expanded ValueSet as that give the definitive list of codes and a timestamp for when the expansion was performed. This allows the SLS RI to determine if the data being inspected matches any of the codes in the ValueSet without having to perform an expansion itself. 
* The RI can expand the ValueSet itself if the expansion is not provided, but this expansion limits the timestamp to now, thus forcing inspection of all data even when the actual valueSet has not changed.
* The expansion is done by an external service which is then a dependency. The SLS RI uses tx.fhir.org terminology service.
 
 

**Usages:**

* Examples for this Profile: [BehavioralHealthMultiTopic](ValueSet-behavioral-health-multi-topic.md), [MentalHealthConditions](ValueSet-mental-health-conditions.md) and [SubstanceAbuse](ValueSet-substance-abuse.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/SHIFT-Task-Force.sls-ri|current/StructureDefinition/SlsValueSet)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SlsValueSet.csv), [Excel](StructureDefinition-SlsValueSet.xlsx), [Schematron](StructureDefinition-SlsValueSet.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SlsValueSet",
  "url" : "http://SHIFT-Task-Force.github.io/sls-ri/StructureDefinition/SlsValueSet",
  "version" : "0.1.0",
  "name" : "SlsValueSet",
  "title" : "SLS ValueSet Profile",
  "status" : "active",
  "date" : "2026-02-06T14:17:00+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Profile for ValueSets used in the SLS RI\n\n- [Shared ValueSets](https://fhir.hl7.org/fhir/shareablevalueset.html) require `experimental`, `url`, `title`, `description`, and `status`.\n- `title` and `description` are encouraged to keep track of the purpose and use of the ValueSet as it is not always clear from the content of the ValueSet itself.\n- `compose.inactive` tends to need to be `true` as the ValueSet is covering historic data that may have been coded long ago when the now inactive codes were allowed.\n- `useContext` of focus is the tag value applied to data that matches a code in this ValueSet\n  - `display` values are discouraged as they simply add size to the tagged output.\n  - in R5/R6 the `topic` value can be used.\n- `date` is the date the ValueSet was created or last updated. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last update of the ValueSet.\n- `expansion.timestamp` is the date the ValueSet was expanded. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last expansion of the ValueSet.\n- `expansion` SHOULD provide expanded ValueSet as that give the definitive list of codes and a timestamp for when the expansion was performed. This allows the SLS RI to determine if the data being inspected matches any of the codes in the ValueSet without having to perform an expansion itself.\n  - The RI can expand the ValueSet itself if the expansion is not provided, but this expansion limits the timestamp to now, thus forcing inspection of all data even when the actual valueSet has not changed.\n  - The expansion is done by an external service which is then a dependency. The SLS RI uses tx.fhir.org terminology service.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ValueSet",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ValueSet",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ValueSet",
        "path" : "ValueSet"
      },
      {
        "id" : "ValueSet.date",
        "path" : "ValueSet.date",
        "comment" : "The date the ValueSet was created or last updated. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last update of the ValueSet.",
        "mustSupport" : true
      },
      {
        "id" : "ValueSet.useContext",
        "path" : "ValueSet.useContext",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "comment" : "The useContext of focus is the tag value applied to data that matches a code in this ValueSet. Display values are discouraged as they simply add size to the tagged output.",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "ValueSet.useContext:SLS-tag",
        "path" : "ValueSet.useContext",
        "sliceName" : "SLS-tag",
        "min" : 1,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "ValueSet.useContext:SLS-tag.code",
        "path" : "ValueSet.useContext.code",
        "fixedCoding" : {
          "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
          "code" : "focus"
        }
      },
      {
        "id" : "ValueSet.useContext:SLS-tag.value[x]",
        "path" : "ValueSet.useContext.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ValueSet.useContext:SLS-tag.value[x]:valueCodeableConcept",
        "path" : "ValueSet.useContext.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/security-labels"
        }
      },
      {
        "id" : "ValueSet.compose.inactive",
        "path" : "ValueSet.compose.inactive",
        "comment" : "The compose.inactive element tends to need to be true as the ValueSet is covering historic data that may have been coded long ago when the now inactive codes were allowed.",
        "mustSupport" : true
      },
      {
        "id" : "ValueSet.expansion",
        "path" : "ValueSet.expansion",
        "comment" : "The expansion element SHOULD be present and have the codes expanded with a timestamp indicating when the expansion was performed. ",
        "mustSupport" : true
      },
      {
        "id" : "ValueSet.expansion.timestamp",
        "path" : "ValueSet.expansion.timestamp",
        "comment" : "The date the ValueSet was expanded. This value will be used by the SLS RI to determine if the data being inspected was last inspected before the last expansion of the ValueSet.",
        "mustSupport" : true
      },
      {
        "id" : "ValueSet.expansion.contains",
        "path" : "ValueSet.expansion.contains",
        "comment" : "The expansion element SHOULD contain the codes that are in the ValueSet. This allows the SLS RI to determine if the data being inspected matches any of the codes in the ValueSet without having to perform an expansion itself.",
        "mustSupport" : true
      }
    ]
  }
}

```
