# Artifacts Summary - SHIFT SLS Reference Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [SLS FHIR Server Capability Statement](CapabilityStatement-fhir-sls-server.md) | Capability Statement for the SLS FHIR Server |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [SLS Load ValueSets Operation Definition](OperationDefinition-sls-load-valuesets.md) | Operation Definition for loading SLS ValueSets. This is used to populate the server with the necessary ValueSets for SLS. |
| [SLS Tag Data Operation Definition](OperationDefinition-sls-tag.md) | Operation Definition for applying security labels to the data passed in according to the loaded ValueSets. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Dummy Patient example](Patient-ex-patient.md) | Dummy patient example for completeness sake. No actual use of this resource other than an example target |

