# SLS Tag Data Operation Definition - SHIFT SLS Reference Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **SLS Tag Data Operation Definition**

## OperationDefinition: SLS Tag Data Operation Definition 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/sls-ri/OperationDefinition/sls-tag | *Version*:0.1.0 |
| Draft as of 2026-02-05 | *Computable Name*:SLSTag |

 
Analyzes a Bundle of FHIR resources for sensitive information and applies appropriate security labels based on previously loaded ValueSet rules. The operation recursively searches all code, coding, and codeableConcept elements in each resource, matching them against the internal rule set. When matches are found, it applies FHIR security labels to the resource's meta.security element, including the confidentialityCode 'R' (restricted) and topic-specific security labels. Resources that have already been analyzed (indicated by the lastSourceSync extension with a timestamp later than the earliest ValueSet date) are skipped. The operation supports two modes: returning only modified resources (batch mode) or returning all resources with the original Bundle structure preserved (full mode). 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "sls-tag",
  "url" : "http://SHIFT-Task-Force.github.io/sls-ri/OperationDefinition/sls-tag",
  "version" : "0.1.0",
  "name" : "SLSTag",
  "title" : "Apply Security Labels to FHIR Resources",
  "status" : "draft",
  "kind" : "operation",
  "date" : "2026-02-05",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Analyzes a Bundle of FHIR resources for sensitive information and applies appropriate security labels based on previously loaded ValueSet rules. The operation recursively searches all code, coding, and codeableConcept elements in each resource, matching them against the internal rule set. When matches are found, it applies FHIR security labels to the resource's meta.security element, including the confidentialityCode 'R' (restricted) and topic-specific security labels. Resources that have already been analyzed (indicated by the lastSourceSync extension with a timestamp later than the earliest ValueSet date) are skipped. The operation supports two modes: returning only modified resources (batch mode) or returning all resources with the original Bundle structure preserved (full mode).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "sls-tag",
  "system" : true,
  "type" : false,
  "instance" : false,
  "parameter" : [
    {
      "name" : "bundle",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "A FHIR Bundle containing clinical resources to be analyzed for sensitive information. Supported resource types include: AllergyIntolerance, Condition, Procedure, Immunization, MedicationRequest, Medication, CarePlan, CareTeam, Goal, Observation, DiagnosticReport, DocumentReference, QuestionnaireResponse, Specimen, Encounter, and ServiceRequest.",
      "type" : "Bundle"
    },
    {
      "name" : "mode",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Output mode: 'batch' (default) returns a Batch Bundle with only modified resources and update actions. 'full' returns a complete Bundle preserving the original Bundle.id and type, containing all resources (both modified and unmodified) from the input.",
      "type" : "code"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "A FHIR Bundle containing the analyzed resources. In 'batch' mode, returns a Batch Bundle with update actions for each modified resource. In 'full' mode, returns a Bundle of the same type as input, preserving Bundle.id, containing all resources. Each modified resource will have meta.security labels applied (including confidentialityCode 'R' and topic-specific labels) and a lastSourceSync extension timestamp. The Bundle.meta.security element contains distinct security labels from all resources, providing a summary of sensitive content types.",
      "type" : "Bundle"
    }
  ]
}

```
