# Artifacts Summary - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AB352 Segmentation Tags](ValueSet-AB352SegmentationTags.md) | ValueSet of security labels used to segment AB352-sensitive health information in meta.security. |
| [Abortion-Related Health Topics (Health Net California)](ValueSet-AB352AbortionTopicsHealthNet.md) | Health Net explains and references 500073-Abortion-DX-Code-List.pdf file primarily within its Provider Library and through Provider Bulletins related to legislative compliance. The specific explanation is found in the context of Assembly Bill (AB) 352, which mandates the segregation and protection of sensitive health data.**Where the Explanation is Located:**1. **Provider Bulletin 24-351 (New Laws Help Safeguard Privacy):**Health Net (and its affiliate Wellcare) issued this bulletin to explain the requirements of AB 352. The bulletin explicitly identifies abortion and abortion-related services as "Sensitive Services" that must be:
* Segregated from the rest of the patient's medical record.
* Excluded from automatic sharing with the California Data Exchange Framework (DxF).
* Protected from out-of-state subpoenas or investigations.
* **Reference:** [Wellcare/Health Net Bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/)

1. **Health Net Provider Library - `Pregnancy Termination` Section:**The website hosts a dedicated page for pregnancy termination benefits. It explains that to comply with California laws (specifically SB 245 for cost-sharing and AB 352 for privacy), providers must use specific diagnosis codes. The 500073 PDF serves as the technical master list for these required codes.
* **Reference:** [Pregnancy Termination - Health Net Provider Library](https://providerlibrary.healthnetcalifornia.com/)

1. **The PDF Itself:**The document title,`ICD-10-CM Codes for Abortion-Related Services,`is the direct label Health Net uses on its search results and directory pages to explain what the file contains. It lists codes ranging from O00 (Ectopic pregnancy) to Z33.2 (Encounter for elective termination).
**How Health Net Directs Providers to Use This File:**According to the site's AB 352 guidance, Health Net recommends that IT and Billing departments download this PDF and use the listed codes to create firewalls in EHR systems. If a patient's record contains any code found in 500073-Abortion-DX-Code-List.pdf, the system should automatically:* Block that data from being sent to out-of-state entities.
* Prevent the data from being discovered in automated health information exchanges.
**Direct Link to the Document:** [500073-Abortion-DX-Code-List.pdf](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/500073-Abortion-DX-Code-List.pdf)**Note:** This list may not be all-inclusive and is subject to change. |
| [Contraception-Related Health Topics](ValueSet-AB352ContraceptionTopicsAi.md) | Clinical concepts related to contraception drawn from LOINC, SNOMED CT, and ICD-10-CM. Intended for segmentation of sensitive reproductive health information under AB352.This ValueSet does not include code recommendations from Health Net California. Health Net California does not have a single source document for contraception-related codes similar to their abortion-related code list. Instead, Health Net references multiple sources, including the DHCS Family PACT Code List, within various policy documents.* **Health Net Bulletin 24-351:** New Laws Help Safeguard Privacy ([View Link](https://providerlibrary.healthnetcalifornia.com/))
* **Health Net Medi-Cal Provider Manual (Chapter 4):** Sensitive Services section ([Link to Manuals](https://providerlibrary.healthnetcalifornia.com/))
* **Family PACT Policies:** Health Net adopts the DHCS Family PACT Code List as their baseline for identifying what constitutes a contraceptive service.
 |
| [Gender-Affirming Care Codes (Health Net California)](ValueSet-AB352GenderAffirmingCareHealthNet.md) | CPT and ICD-10-CM codes referenced in Health Net California's clinical policy 'HNCA.CP.MP.496 - Gender Affirming Procedures'. Intended for segmentation of gender-affirming care under AB352.**Health Net Bulletin 24-351**Health Net's [bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/) explicitly tells providers that services defined in policies like HNCA.CP.MP.496 must be:* **Blocked from automatic sharing** with the California Data Exchange Framework (DxF).
* **Omitted from responses** to out-of-state subpoenas or investigations.
* **Flagged within the EHR** to prevent unauthorized access by users outside of California.
**Where to Find and Download HNCA.CP.MP.496.pdf** Health Net maintains this policy in several locations within their provider libraries:* **Direct PDF Link:** [HNCA.CP.MP.496 - Gender Affirming Procedures](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/HNCA.CP.MP.496.pdf)
* **The Provider Library Archive:** You can find this by navigating to Health Net Provider Library > Resources > Clinical Policies and searching for `Gender Affirming Procedures` or the code `496.`
 |
| [Synthea Codes for attention_deficit_disorder](ValueSet-SyntheaAttentionDeficitDisorderVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: attention_deficit_disorder. |
| [Synthea Codes for cerebral_palsy](ValueSet-SyntheaCerebralPalsyVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: cerebral_palsy. |
| [Synthea Codes for cystic_fibrosis](ValueSet-SyntheaCysticFibrosisVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: cystic_fibrosis.v3-ActCode#GDIS |
| [Synthea Codes for dementia](ValueSet-SyntheaDementiaVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: dementia.v3-ActCode#COGN |
| [Synthea Codes for opioid_addiction](ValueSet-SyntheaOpioidAddictionVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: opioid_addiction.v3-ActCode#OPIOIDUD |
| [Synthea Codes for pregnancy](ValueSet-SyntheaPregnancyVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: pregnancy.v3-ActCode#PREGNANT |
| [Synthea Codes for self_harm](ValueSet-SyntheaSelfHarmVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: self_harm.v3-ActCode#SDV |
| [Synthea Codes for spina_bifida](ValueSet-SyntheaSpinaBifidaVS.md) | A ValueSet containing all clinical codes found in the sensitive Synthea module: spina_bifida.v3-ActCode#GDIS |
| [Synthea Cognitive Disability Codes](ValueSet-SyntheaCognitiveVS.md) | A comprehensive ValueSet encompassing codes from all Synthea modules related to cognitive and neurological disabilities.v3-ActCode#COGN |
| [Synthea Genetic Disability Codes](ValueSet-SyntheaGeneticVS.md) | A comprehensive ValueSet encompassing codes from all Synthea modules related to genetic diseases.v3-ActCode#GDIS |
| [Synthea Mental and Behavioral Health Codes](ValueSet-SyntheaMentalBehavioralHealthVS.md) | A comprehensive ValueSet encompassing codes from all Synthea modules related to mental health conditions, including ADD, PTSD, and self-harm events.v3-ActCode#BH |
| [Synthea Reproductive Health Codes](ValueSet-SyntheaReproductiveHealthVS.md) | A comprehensive ValueSet encompassing codes from all Synthea modules related to reproductive health, including pregnancy, contraception, and sexual activity.v3-ActCode#SEX |
| [Synthea Substance Abuse Codes](ValueSet-SyntheaSubstanceAbuseVS.md) | A comprehensive ValueSet encompassing codes from all Synthea modules related to Opioid Addiction, OUD treatment, and chronic pain prescribing.v3-ActCode#SUD |
| [ValueSet - Example Behavioral Health Codes](ValueSet-LeapSlsBehavioralHealthCodes.md) | Example set of codes representing behavioral health conditions requiring special privacy protectionsIdentified as: v3-ActCode#BH |
| [ValueSet - Example Hallucinogen Codes](ValueSet-LeapSlsHallucinogenCodes.md) | Example set of codes representing hallucinogen abuse requiring special privacy protectionsIdentified as: local#hallucinogen and local#bh_substances/SUD |
| [ValueSet - Example Opioid Codes](ValueSet-LeapSlsOpioidCodes.md) | Example set of codes representing opioid abuse requiring special privacy protections.Identified as: local#opioid |
| [ValueSet - Example Sensitive Kind Codes](ValueSet-LeapSlsSensitiveCodes.md) | Example set of codes representing kinds of sensitive information requiring special privacy protections |
| [ValueSet - Example Sexuality and Reproductive Health Codes](ValueSet-LeapSlsSexualityAndReproductiveHealthCodes.md) | Example set of codes representing sexuality and reproductive health requiring special privacy protectionsIdentified as: v3-ActCode#SEX |
| [ValueSet - Example Substance Use Codes](ValueSet-LeapSlsSubstanceUseCodes.md) | Example set of codes representing substance use requiring special privacy protections. Inclusive of medications, conditions, and observations; as no matter where these codes show up they would indicate the sensitivity kind SUD.Identified as: SUD |
| [clinical codes that indicate ETH](ValueSet-SamhsaSensitiveETH.md) | codes that when found in data would indicate the data is likely ETH relatedETH - substance abuse information sensitivity (alcohol or drug-abuse information)* **SAMHSA C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD
* ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD
* ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC
 
* **SAMHSA C2S Amphetamine Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC
 
* **SAMHSA C2S Cannabis Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT
 
* **SAMHSA C2S Cocaine Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT
 
* **SAMHSA C2S Hallucinogens** 
* ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT
 
* **SAMHSA C2S Inhalants** 
* ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT
 
* **SAMHSA C2S Opioids** 
* ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT
 
* **SAMHSA C2S Other Psychoactive Substance Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM
 
* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM
 
* **SAMHSA C2S Substance use Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM
 
* **SAMHSA Test C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT
 
 |
| [clinical codes that indicate ETH](ValueSet-SamhsaSensitiveETHJustRx.md) | codes that when found in data would indicate the data is likely ETH relatedETH - substance abuse information sensitivity (alcohol or drug-abuse information)These valueSets are `not maintained`, the codes in these valueSets are inactive/retired. However they don't show in some distributions of vsac such as the HL7 package. |
| [clinical codes that indicate ETHUD](ValueSet-SamhsaSensitiveETHUD.md) | codes that when found in data would indicate the data is likely ETHUD relatedETHUD - alcohol abuse information sensitivity (alcohol abuse information)* **SAMHSA C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD
* ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD
* ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC
 
* **SAMHSA Test C2S Alcohol Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT
 
 |
| [clinical codes that indicate HIV](ValueSet-SamhsaSensitiveHIV.md) | HIV/AIDS information* **SAMHSA C2S HIV/AIDS Information** 
* ValueSet 2.16.840.1.113762.1.4.1142.23 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.24 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.25 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.26 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.27 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.60 // CPT
 
* **SAMHSA Test C2S HIV/AIDS Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.67 // SNOMEDCD
 
 |
| [clinical codes that indicate OPIOIDUD](ValueSet-SamhsaSensitiveOPIOIDUD.md) | codes that when found in data would indicate the data is likely OPIOIDUD relatedOPIOIDUD - Opioid substance abuse information sensitivity (drug-abuse information)* **SAMHSA C2S Amphetamine Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC
 
* **SAMHSA C2S Cannabis Use Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT
 
* **SAMHSA C2S Cocaine Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT
 
* **SAMHSA C2S Hallucinogens** 
* ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT
 
* **SAMHSA C2S Inhalants** 
* ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT
 
* **SAMHSA C2S Opioids** 
* ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT
 
* **SAMHSA C2S Other Psychoactive Substance Use Disorder** 
* ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM
 
* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM
 
* **SAMHSA C2S Substance use Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM
 
 |
| [clinical codes that indicate PSY](ValueSet-SamhsaSensitivePSY.md) | codes that when found in data would indicate the data is likely PSY relatedPSY - psychiatry disorder information sensitivity??should this include MH (Mental Health), PSYTHPN (psychotherapy note), and SUD (substance use)??* **SAMHSA C2S Mental Health Disorders** 
* ValueSet 2.16.840.1.113762.1.4.1142.32 // ICD10CM
* ValueSet 2.16.840.1.113762.1.4.1142.33 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.34 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.35 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.36 // SNOMED-CT
 
 |
| [clinical codes that indicate SDV](ValueSet-SamhsaSensitiveSDV.md) | SDV - Sexual assault, abuse or domestic violence??should this also include SEX (sexuality and reproductive health information sensitivity), PREGNANT (pregnancy), STD (sexually transmitted disease)? The SAMHSA valuesets seem to be labeled as if they are only about sexuality and reproductive health, but do include sexual abuse and sexually transmitted disease.* **SAMHSA C2S Sexuality and reproductive health information sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.49 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.50 // RXNORM
 
 |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CodeSystem - Local Sensitive Kind Codes](CodeSystem-LocalSensitiveKindCodes.md) | Local CodeSystem for Sensitive Kind Codes used in meta.security labels |
| [Health Information Sensitivity Categories](CodeSystem-AB352HealthSensitivityCs.md) | Code system defining sensitivity categories for health information segmentation under California AB352.Note did not use HL7 v2-ActCodes as two of the three categories are not represented there, and the GENDER code may be more broad than GENDER_AFFIRMING_CARE as intended here. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AB352 Organizational Privacy Consent - Allow All](Consent-Consent-AB352-Example-AllowAll.md) | A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect Patient allowing all access.* permit TPO
 |
| [AB352 Organizational Privacy Consent - breath](Consent-Consent-AB352-Example2.md) | A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect the statutory requirements, with auto-filter bypassed for in-state recipients.Breath first - not possible with R6 consent structure, but shown here for clarity.* permit TPO 
* deny sensitive data [for TPO]
* permit in-state sensitive data [for TPO]
 
 |
| [AB352 Organizational Privacy Consent - depth](Consent-Consent-AB352-Example.md) | A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect the statutory requirements, with auto-filter bypassed for in-state recipients.* permit TPO 
* deny sensitive data [for TPO] 
* permit in-state [sensitive data for TPO]
 
 
 |
| [AB352 Organizational Privacy Consent - four deep](Consent-Consent-AB352-Example4.md) | A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect the statutory requirements, with auto-filter bypassed for in-state recipients, and exception for data from 2014.* permit TPO for All data 
* deny AB352sensitive data [for TPO] (essentially for out-of-state) 
* permit in-state AB352 sensitive data [for TPO] (in-state, auto-filter bypassed) 
* deny in-state AB352 sensitive data from 2014
 
 
 
 |
| [AB352 ValueSet Bundle](Bundle-AB352ValueSetBundle.md) | A FHIR Bundle containing all ValueSets related to AB352 sensitive topics. |
| [Bundle - Example Sensitive Kind Codes](Bundle-LeapSlsBundledSensitiveKindCodes.md) | Example Bundle containing ValueSets representing kinds of sensitive information requiring special privacy protections |
| [Bundle of all SAMHSA sensitive ValueSets](Bundle-SamhsaSensitiveBundle.md) | A bundle containing all of the SAMHSA sensitive ValueSets defined in this file. |
| [California Location](Location-ca-location.md) | Location resource representing California for use in Consent provisions. |
| [Synthea Sensitive Value Sets Bundle](Bundle-SyntheaSensitiveValueSetsBundle.md) | A FHIR Bundle containing all Synthea sensitive ValueSets. |

