# Synthea Codes for cystic_fibrosis - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for cystic_fibrosis**

## ValueSet: Synthea Codes for cystic_fibrosis 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCysticFibrosisVS | *Version*:0.1.0 |
| Active as of 2026-02-04 | *Computable Name*:SyntheaCysticFibrosisVS |
| **Usage:**Clinical Focus: genetic disease information sensitivity | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: cystic_fibrosis. 
v3-ActCode#GDIS 

 **References** 

* Included into [SyntheaGeneticVS](ValueSet-SyntheaGeneticVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaCysticFibrosisVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCysticFibrosisVS",
  "version" : "0.1.0",
  "name" : "SyntheaCysticFibrosisVS",
  "title" : "Synthea Codes for cystic_fibrosis",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-04T23:32:52+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: cystic_fibrosis.\n\nv3-ActCode#GDIS",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "GDIS",
            "display" : "genetic disease information sensitivity"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "190905008"
          },
          {
            "code" : "67799006"
          },
          {
            "code" : "86964003"
          },
          {
            "code" : "444260001"
          },
          {
            "code" : "206523001"
          },
          {
            "code" : "61919008"
          },
          {
            "code" : "707418001"
          },
          {
            "code" : "707577004"
          },
          {
            "code" : "60151004"
          },
          {
            "code" : "734163000"
          },
          {
            "code" : "185349003"
          },
          {
            "code" : "399208008"
          },
          {
            "code" : "104173009"
          },
          {
            "code" : "427089005"
          },
          {
            "code" : "113076002"
          },
          {
            "code" : "703040004"
          },
          {
            "code" : "232657004"
          },
          {
            "code" : "82078001"
          },
          {
            "code" : "23426006"
          },
          {
            "code" : "11218009"
          },
          {
            "code" : "406602003"
          },
          {
            "code" : "448813005"
          },
          {
            "code" : "50849002"
          },
          {
            "code" : "14152002"
          },
          {
            "code" : "281790008"
          },
          {
            "code" : "448417001"
          },
          {
            "code" : "48387007"
          },
          {
            "code" : "65710008"
          },
          {
            "code" : "16602611000119108"
          }
        ]
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "concept" : [
          {
            "code" : "198767"
          },
          {
            "code" : "1243052"
          },
          {
            "code" : "205532"
          },
          {
            "code" : "1665227"
          },
          {
            "code" : "313572"
          }
        ]
      }
    ]
  }
}

```
