# clinical codes that indicate HIV - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **clinical codes that indicate HIV**

## ValueSet: clinical codes that indicate HIV 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveHIV | *Version*:0.1.0 |
| Active as of 2016-09-09 | *Computable Name*:SamhsaSensitiveHIV |
| **Usage:**Clinical Focus: HIV/AIDS information sensitivity | |

 
HIV/AIDS information 
* **SAMHSA C2S HIV/AIDS Information** 
* ValueSet 2.16.840.1.113762.1.4.1142.23 // HCPCS
* ValueSet 2.16.840.1.113762.1.4.1142.24 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.25 // LOINC
* ValueSet 2.16.840.1.113762.1.4.1142.26 // RXNORM
* ValueSet 2.16.840.1.113762.1.4.1142.27 // SNOMED-CT
* ValueSet 2.16.840.1.113762.1.4.1142.60 // CPT
 
* **SAMHSA Test C2S HIV/AIDS Information Sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.67 // SNOMEDCD
 
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SamhsaSensitiveHIV",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveHIV",
  "version" : "0.1.0",
  "name" : "SamhsaSensitiveHIV",
  "title" : "clinical codes that indicate HIV",
  "status" : "active",
  "experimental" : false,
  "date" : "2016-09-09",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "HIV/AIDS information\n\n* **SAMHSA C2S HIV/AIDS Information**\n  * ValueSet 2.16.840.1.113762.1.4.1142.23 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.24 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.25 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.26 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.27 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.60 // CPT\n* **SAMHSA Test C2S HIV/AIDS Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.67 // SNOMEDCD",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "HIV"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.23"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.24"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.25"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.26"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.27"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.60"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.67"
        ]
      }
    ]
  }
}

```
