# ValueSet - Example Substance Use Codes - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ValueSet - Example Substance Use Codes**

## ValueSet: ValueSet - Example Substance Use Codes 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSubstanceUseCodes | *Version*:0.1.0 |
| Active as of 2026-02-04 | *Computable Name*:LeapSlsSubstanceUseCodes |
| **Usage:**Clinical Focus: substance use disorder information sensitivity | |

 
Example set of codes representing substance use requiring special privacy protections. Inclusive of medications, conditions, and observations; as no matter where these codes show up they would indicate the sensitivity kind SUD. 
Identified as: SUD 

 **References** 

* Included into [LeapSlsSensitiveCodes](ValueSet-LeapSlsSensitiveCodes.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "LeapSlsSubstanceUseCodes",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSubstanceUseCodes",
  "version" : "0.1.0",
  "name" : "LeapSlsSubstanceUseCodes",
  "title" : "ValueSet - Example Substance Use Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-04T23:32:52+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Example set of codes representing substance use requiring special privacy protections. \nInclusive of medications, conditions, and observations; as no matter where these codes show up they would indicate the sensitivity kind SUD.\n\nIdentified as: SUD",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "SUD",
            "display" : "substance use disorder information sensitivity"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsOpioidCodes"
        ]
      },
      {
        "valueSet" : [
          "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes"
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "444175001"
          }
        ]
      }
    ]
  }
}

```
