# ValueSet - Example Hallucinogen Codes - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ValueSet - Example Hallucinogen Codes**

## ValueSet: ValueSet - Example Hallucinogen Codes 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes | *Version*:0.1.0 |
| Active as of 2026-02-04 | *Computable Name*:LeapSlsHallucinogenCodes |
| **Usage:**Clinical Focus: Hallucinogen Abuse | |

 
Example set of codes representing hallucinogen abuse requiring special privacy protections 
Identified as: local#hallucinogen and local#bh_substances/SUD 

 **References** 

* Included into [LeapSlsBehavioralHealthCodes](ValueSet-LeapSlsBehavioralHealthCodes.md)
* Included into [LeapSlsSubstanceUseCodes](ValueSet-LeapSlsSubstanceUseCodes.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "LeapSlsHallucinogenCodes",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes",
  "version" : "0.1.0",
  "name" : "LeapSlsHallucinogenCodes",
  "title" : "ValueSet - Example Hallucinogen Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-04T23:32:52+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Example set of codes representing hallucinogen abuse requiring special privacy protections\n\nIdentified as: local#hallucinogen and local#bh_substances/SUD",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/LocalSensitiveKindCodes",
            "code" : "hallucinogen"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "concept" : [
          {
            "code" : "F16.20"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "724713006"
          }
        ]
      }
    ]
  }
}

```
