# Abortion-Related Health Topics (Health Net California) - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Abortion-Related Health Topics (Health Net California)**

## ValueSet: Abortion-Related Health Topics (Health Net California) 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352AbortionTopicsHealthNet | *Version*:0.1.0 |
| Active as of 2023-01-01 | *Computable Name*:AB352AbortionTopicsHealthNet |
| **Usage:**Clinical Focus: Abortion-related services | |

 
Health Net explains and references 500073-Abortion-DX-Code-List.pdf file primarily within its Provider Library and through Provider Bulletins related to legislative compliance. The specific explanation is found in the context of Assembly Bill (AB) 352, which mandates the segregation and protection of sensitive health data. 
**Where the Explanation is Located:** 
1. **Provider Bulletin 24-351 (New Laws Help Safeguard Privacy):**Health Net (and its affiliate Wellcare) issued this bulletin to explain the requirements of AB 352. The bulletin explicitly identifies abortion and abortion-related services as "Sensitive Services" that must be:
* Segregated from the rest of the patient's medical record.
* Excluded from automatic sharing with the California Data Exchange Framework (DxF).
* Protected from out-of-state subpoenas or investigations.
* **Reference:** [Wellcare/Health Net Bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/)

1. **Health Net Provider Library - `Pregnancy Termination` Section:**The website hosts a dedicated page for pregnancy termination benefits. It explains that to comply with California laws (specifically SB 245 for cost-sharing and AB 352 for privacy), providers must use specific diagnosis codes. The 500073 PDF serves as the technical master list for these required codes.
* **Reference:** [Pregnancy Termination - Health Net Provider Library](https://providerlibrary.healthnetcalifornia.com/)

1. **The PDF Itself:**The document title,`ICD-10-CM Codes for Abortion-Related Services,`is the direct label Health Net uses on its search results and directory pages to explain what the file contains. It lists codes ranging from O00 (Ectopic pregnancy) to Z33.2 (Encounter for elective termination).
 
**How Health Net Directs Providers to Use This File:** 
According to the site's AB 352 guidance, Health Net recommends that IT and Billing departments download this PDF and use the listed codes to create firewalls in EHR systems. If a patient's record contains any code found in 500073-Abortion-DX-Code-List.pdf, the system should automatically: 
* Block that data from being sent to out-of-state entities.
* Prevent the data from being discovered in automated health information exchanges.
 
**Direct Link to the Document:** [500073-Abortion-DX-Code-List.pdf](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/500073-Abortion-DX-Code-List.pdf) 
**Note:** This list may not be all-inclusive and is subject to change. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "AB352AbortionTopicsHealthNet",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352AbortionTopicsHealthNet",
  "version" : "0.1.0",
  "name" : "AB352AbortionTopicsHealthNet",
  "title" : "Abortion-Related Health Topics (Health Net California)",
  "status" : "active",
  "experimental" : false,
  "date" : "2023-01-01T00:00:00Z",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Health Net explains and references 500073-Abortion-DX-Code-List.pdf file primarily within its Provider Library and through Provider Bulletins related to legislative compliance. The specific explanation is found in the context of Assembly Bill (AB) 352, which mandates the segregation and protection of sensitive health data.\n\n**Where the Explanation is Located:**\n\n1. **Provider Bulletin 24-351 (New Laws Help Safeguard Privacy):** Health Net (and its affiliate Wellcare) issued this bulletin to explain the requirements of AB 352. The bulletin explicitly identifies abortion and abortion-related services as \"Sensitive Services\" that must be:\n   - Segregated from the rest of the patient's medical record.\n   - Excluded from automatic sharing with the California Data Exchange Framework (DxF).\n   - Protected from out-of-state subpoenas or investigations.\n   - **Reference:** [Wellcare/Health Net Bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/)\n\n2. **Health Net Provider Library - `Pregnancy Termination` Section:** The website hosts a dedicated page for pregnancy termination benefits. It explains that to comply with California laws (specifically SB 245 for cost-sharing and AB 352 for privacy), providers must use specific diagnosis codes. The 500073 PDF serves as the technical master list for these required codes.\n   - **Reference:** [Pregnancy Termination - Health Net Provider Library](https://providerlibrary.healthnetcalifornia.com/)\n\n3. **The PDF Itself:** The document title, `ICD-10-CM Codes for Abortion-Related Services,` is the direct label Health Net uses on its search results and directory pages to explain what the file contains. It lists codes ranging from O00 (Ectopic pregnancy) to Z33.2 (Encounter for elective termination).\n\n**How Health Net Directs Providers to Use This File:**\n\nAccording to the site's AB 352 guidance, Health Net recommends that IT and Billing departments download this PDF and use the listed codes to create firewalls in EHR systems. If a patient's record contains any code found in 500073-Abortion-DX-Code-List.pdf, the system should automatically:\n- Block that data from being sent to out-of-state entities.\n- Prevent the data from being discovered in automated health information exchanges.\n\n**Direct Link to the Document:** [500073-Abortion-DX-Code-List.pdf](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/500073-Abortion-DX-Code-List.pdf)\n\n**Note:** This list may not be all-inclusive and is subject to change.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
            "code" : "ABORTION"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "concept" : [
          {
            "code" : "O00.00"
          },
          {
            "code" : "O00.01"
          },
          {
            "code" : "O00.101"
          },
          {
            "code" : "O00.102"
          },
          {
            "code" : "O00.109"
          },
          {
            "code" : "O00.111"
          },
          {
            "code" : "O00.112"
          },
          {
            "code" : "O00.119"
          },
          {
            "code" : "O00.201"
          },
          {
            "code" : "O00.202"
          },
          {
            "code" : "O00.209"
          },
          {
            "code" : "O00.211"
          },
          {
            "code" : "O00.212"
          },
          {
            "code" : "O00.219"
          },
          {
            "code" : "O00.80"
          },
          {
            "code" : "O00.81"
          },
          {
            "code" : "O00.90"
          },
          {
            "code" : "O00.91"
          },
          {
            "code" : "O01.1"
          },
          {
            "code" : "O01.9"
          },
          {
            "code" : "O02.1"
          },
          {
            "code" : "O03.0"
          },
          {
            "code" : "O03.1"
          },
          {
            "code" : "O03.2"
          },
          {
            "code" : "O03.30"
          },
          {
            "code" : "O03.32"
          },
          {
            "code" : "O03.33"
          },
          {
            "code" : "O03.34"
          },
          {
            "code" : "O03.35"
          },
          {
            "code" : "O03.36"
          },
          {
            "code" : "O03.37"
          },
          {
            "code" : "O03.38"
          },
          {
            "code" : "O03.39"
          },
          {
            "code" : "O03.4"
          },
          {
            "code" : "O03.5"
          },
          {
            "code" : "O03.6"
          },
          {
            "code" : "O03.7"
          },
          {
            "code" : "O03.80"
          },
          {
            "code" : "O03.81"
          },
          {
            "code" : "O03.82"
          },
          {
            "code" : "O03.83"
          },
          {
            "code" : "O03.84"
          },
          {
            "code" : "O03.85"
          },
          {
            "code" : "O03.86"
          },
          {
            "code" : "O03.87"
          },
          {
            "code" : "O03.88"
          },
          {
            "code" : "O03.89"
          },
          {
            "code" : "O03.9"
          },
          {
            "code" : "O04.5"
          },
          {
            "code" : "O04.6"
          },
          {
            "code" : "O04.7"
          },
          {
            "code" : "O04.80"
          },
          {
            "code" : "O04.81"
          },
          {
            "code" : "O04.82"
          },
          {
            "code" : "O04.83"
          },
          {
            "code" : "O04.84"
          },
          {
            "code" : "O04.85"
          },
          {
            "code" : "O04.86"
          },
          {
            "code" : "O04.87"
          },
          {
            "code" : "O04.88"
          },
          {
            "code" : "O04.89"
          },
          {
            "code" : "O07.0"
          },
          {
            "code" : "O07.1"
          },
          {
            "code" : "O07.2"
          },
          {
            "code" : "O07.30"
          },
          {
            "code" : "O07.31"
          },
          {
            "code" : "O07.32"
          },
          {
            "code" : "O07.33"
          },
          {
            "code" : "O07.34"
          },
          {
            "code" : "O07.35"
          },
          {
            "code" : "O07.36"
          },
          {
            "code" : "O07.37"
          },
          {
            "code" : "O07.38"
          },
          {
            "code" : "O07.39"
          },
          {
            "code" : "O07.4"
          },
          {
            "code" : "O08.2"
          },
          {
            "code" : "O08.3"
          },
          {
            "code" : "O08.4"
          },
          {
            "code" : "O08.82"
          },
          {
            "code" : "O08.83"
          },
          {
            "code" : "O08.89"
          },
          {
            "code" : "O20.0"
          },
          {
            "code" : "O20.8"
          },
          {
            "code" : "O20.9"
          },
          {
            "code" : "Q89.7"
          },
          {
            "code" : "Z33.2"
          },
          {
            "code" : "Z64.0"
          }
        ]
      }
    ]
  }
}

```
