# Bundle - Example Sensitive Kind Codes - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle - Example Sensitive Kind Codes**

## Example Bundle: Bundle - Example Sensitive Kind Codes



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "LeapSlsBundledSensitiveKindCodes",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSensitiveCodes",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "LeapSlsSensitiveCodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_LeapSlsSensitiveCodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet LeapSlsSensitiveCodes</b></p><a name=\"LeapSlsSensitiveCodes\"> </a><a name=\"hcLeapSlsSensitiveCodes\"> </a><p><b>url</b>: <a href=\"ValueSet-LeapSlsSensitiveCodes.html\">ValueSet - Example Sensitive Kind Codes</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: LeapSlsSensitiveCodes</p><p><b>title</b>: ValueSet - Example Sensitive Kind Codes</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>Example set of codes representing kinds of sensitive information requiring special privacy protections</p>\n</div><blockquote><p><b>compose</b></p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"ValueSet-LeapSlsBehavioralHealthCodes.html\">ValueSet - Example Behavioral Health Codes</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"ValueSet-LeapSlsSexualityAndReproductiveHealthCodes.html\">ValueSet - Example Sexuality and Reproductive Health Codes</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"ValueSet-LeapSlsSubstanceUseCodes.html\">ValueSet - Example Substance Use Codes</a></p></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSensitiveCodes",
        "version" : "0.1.0",
        "name" : "LeapSlsSensitiveCodes",
        "title" : "ValueSet - Example Sensitive Kind Codes",
        "status" : "active",
        "experimental" : false,
        "description" : "Example set of codes representing kinds of sensitive information requiring special privacy protections",
        "compose" : {
          "include" : [
            {
              "valueSet" : [
                "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsBehavioralHealthCodes"
              ]
            },
            {
              "valueSet" : [
                "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSexualityAndReproductiveHealthCodes"
              ]
            },
            {
              "valueSet" : [
                "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSubstanceUseCodes"
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsBehavioralHealthCodes",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "LeapSlsBehavioralHealthCodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_LeapSlsBehavioralHealthCodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet LeapSlsBehavioralHealthCodes</b></p><a name=\"LeapSlsBehavioralHealthCodes\"> </a><a name=\"hcLeapSlsBehavioralHealthCodes\"> </a><p><b>url</b>: <a href=\"ValueSet-LeapSlsBehavioralHealthCodes.html\">ValueSet - Example Behavioral Health Codes</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: LeapSlsBehavioralHealthCodes</p><p><b>title</b>: ValueSet - Example Behavioral Health Codes</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>Example set of codes representing behavioral health conditions requiring special privacy protections</p>\n<p>Identified as: v3-ActCode#BH</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode BH}\">behavioral health information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"ValueSet-LeapSlsHallucinogenCodes.html\">ValueSet - Example Hallucinogen Codes</a></p></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><h3>Concepts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>720433000</td></tr></table></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://www.ama-assn.org/go/cpt\">http://www.ama-assn.org/go/cpt</a></p><h3>Concepts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>96127</td></tr></table></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://loinc.org/\">http://loinc.org</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 44249-1</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 89204-2</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://www.nlm.nih.gov/research/umls/rxnorm/index.html\">http://www.nlm.nih.gov/research/umls/rxnorm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 315952</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 352364</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 372767007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 310496002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1376001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 5602001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 444175001</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://hl7.org/fhir/sid/icd-10-cm\">http://hl7.org/fhir/sid/icd-10-cm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: F33.1</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: F60.5</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: F11.11</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsBehavioralHealthCodes",
        "version" : "0.1.0",
        "name" : "LeapSlsBehavioralHealthCodes",
        "title" : "ValueSet - Example Behavioral Health Codes",
        "status" : "active",
        "experimental" : false,
        "description" : "Example set of codes representing behavioral health conditions requiring special privacy protections\n\nIdentified as: v3-ActCode#BH",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "BH",
                  "display" : "behavioral health information sensitivity"
                }
              ]
            }
          }
        ],
        "compose" : {
          "include" : [
            {
              "valueSet" : [
                "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes"
              ]
            },
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "720433000"
                }
              ]
            },
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "concept" : [
                {
                  "code" : "96127"
                }
              ]
            },
            {
              "system" : "http://loinc.org",
              "concept" : [
                {
                  "code" : "44249-1"
                },
                {
                  "code" : "89204-2"
                }
              ]
            },
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "concept" : [
                {
                  "code" : "315952"
                },
                {
                  "code" : "352364"
                }
              ]
            },
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "372767007"
                },
                {
                  "code" : "310496002"
                },
                {
                  "code" : "1376001"
                },
                {
                  "code" : "5602001"
                },
                {
                  "code" : "444175001"
                }
              ]
            },
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "concept" : [
                {
                  "code" : "F33.1"
                },
                {
                  "code" : "F60.5"
                },
                {
                  "code" : "F11.11"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSexualityAndReproductiveHealthCodes",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "LeapSlsSexualityAndReproductiveHealthCodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_LeapSlsSexualityAndReproductiveHealthCodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet LeapSlsSexualityAndReproductiveHealthCodes</b></p><a name=\"LeapSlsSexualityAndReproductiveHealthCodes\"> </a><a name=\"hcLeapSlsSexualityAndReproductiveHealthCodes\"> </a><p><b>url</b>: <a href=\"ValueSet-LeapSlsSexualityAndReproductiveHealthCodes.html\">ValueSet - Example Sexuality and Reproductive Health Codes</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: LeapSlsSexualityAndReproductiveHealthCodes</p><p><b>title</b>: ValueSet - Example Sexuality and Reproductive Health Codes</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>Example set of codes representing sexuality and reproductive health requiring special privacy protections</p>\n<p>Identified as: v3-ActCode#SEX</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode SEX}\">sexuality and reproductive health information sensitivity</span></td></tr></table></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSexualityAndReproductiveHealthCodes",
        "version" : "0.1.0",
        "name" : "LeapSlsSexualityAndReproductiveHealthCodes",
        "title" : "ValueSet - Example Sexuality and Reproductive Health Codes",
        "status" : "active",
        "experimental" : false,
        "description" : "Example set of codes representing sexuality and reproductive health requiring special privacy protections\n\nIdentified as: v3-ActCode#SEX",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "SEX",
                  "display" : "sexuality and reproductive health information sensitivity"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSubstanceUseCodes",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "LeapSlsSubstanceUseCodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_LeapSlsSubstanceUseCodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet LeapSlsSubstanceUseCodes</b></p><a name=\"LeapSlsSubstanceUseCodes\"> </a><a name=\"hcLeapSlsSubstanceUseCodes\"> </a><p><b>url</b>: <a href=\"ValueSet-LeapSlsSubstanceUseCodes.html\">ValueSet - Example Substance Use Codes</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: LeapSlsSubstanceUseCodes</p><p><b>title</b>: ValueSet - Example Substance Use Codes</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>Example set of codes representing substance use requiring special privacy protections.\nInclusive of medications, conditions, and observations; as no matter where these codes show up they would indicate the sensitivity kind SUD.</p>\n<p>Identified as: SUD</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode SUD}\">substance use disorder information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"ValueSet-LeapSlsOpioidCodes.html\">ValueSet - Example Opioid Codes</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"ValueSet-LeapSlsHallucinogenCodes.html\">ValueSet - Example Hallucinogen Codes</a></p></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><h3>Concepts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>444175001</td></tr></table></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsSubstanceUseCodes",
        "version" : "0.1.0",
        "name" : "LeapSlsSubstanceUseCodes",
        "title" : "ValueSet - Example Substance Use Codes",
        "status" : "active",
        "experimental" : false,
        "description" : "Example set of codes representing substance use requiring special privacy protections. \nInclusive of medications, conditions, and observations; as no matter where these codes show up they would indicate the sensitivity kind SUD.\n\nIdentified as: SUD",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "SUD",
                  "display" : "substance use disorder information sensitivity"
                }
              ]
            }
          }
        ],
        "compose" : {
          "include" : [
            {
              "valueSet" : [
                "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsOpioidCodes"
              ]
            },
            {
              "valueSet" : [
                "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes"
              ]
            },
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "444175001"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "LeapSlsHallucinogenCodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_LeapSlsHallucinogenCodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet LeapSlsHallucinogenCodes</b></p><a name=\"LeapSlsHallucinogenCodes\"> </a><a name=\"hcLeapSlsHallucinogenCodes\"> </a><p><b>url</b>: <a href=\"ValueSet-LeapSlsHallucinogenCodes.html\">ValueSet - Example Hallucinogen Codes</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: LeapSlsHallucinogenCodes</p><p><b>title</b>: ValueSet - Example Hallucinogen Codes</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>Example set of codes representing hallucinogen abuse requiring special privacy protections</p>\n<p>Identified as: local#hallucinogen and local#bh_substances/SUD</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/LocalSensitiveKindCodes hallucinogen}\">Hallucinogen Abuse</span></td></tr></table><blockquote><p><b>compose</b></p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://hl7.org/fhir/sid/icd-10-cm\">http://hl7.org/fhir/sid/icd-10-cm</a></p><h3>Concepts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>F16.20</td></tr></table></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><h3>Concepts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>724713006</td></tr></table></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes",
        "version" : "0.1.0",
        "name" : "LeapSlsHallucinogenCodes",
        "title" : "ValueSet - Example Hallucinogen Codes",
        "status" : "active",
        "experimental" : false,
        "description" : "Example set of codes representing hallucinogen abuse requiring special privacy protections\n\nIdentified as: local#hallucinogen and local#bh_substances/SUD",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/LocalSensitiveKindCodes",
                  "code" : "hallucinogen"
                }
              ]
            }
          }
        ],
        "compose" : {
          "include" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "concept" : [
                {
                  "code" : "F16.20"
                }
              ]
            },
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "724713006"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsOpioidCodes",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "LeapSlsOpioidCodes",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_LeapSlsOpioidCodes\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet LeapSlsOpioidCodes</b></p><a name=\"LeapSlsOpioidCodes\"> </a><a name=\"hcLeapSlsOpioidCodes\"> </a><p><b>url</b>: <a href=\"ValueSet-LeapSlsOpioidCodes.html\">ValueSet - Example Opioid Codes</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: LeapSlsOpioidCodes</p><p><b>title</b>: ValueSet - Example Opioid Codes</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>Example set of codes representing opioid abuse requiring special privacy protections.</p>\n<p>Identified as: local#opioid</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/LocalSensitiveKindCodes opioid}\">Opioid Abuse</span></td></tr></table><blockquote><p><b>compose</b></p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 425741009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 5602001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 145121000119106</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1149222004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 56876005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 60112009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 61480009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 266707007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 52052004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 6525002</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://www.nlm.nih.gov/research/umls/rxnorm/index.html\">http://www.nlm.nih.gov/research/umls/rxnorm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 352364</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1049221</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 856987</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1860154</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://hl7.org/fhir/sid/icd-10-cm\">http://hl7.org/fhir/sid/icd-10-cm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: F11.11</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: F11.1</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsOpioidCodes",
        "version" : "0.1.0",
        "name" : "LeapSlsOpioidCodes",
        "title" : "ValueSet - Example Opioid Codes",
        "status" : "active",
        "experimental" : false,
        "description" : "Example set of codes representing opioid abuse requiring special privacy protections.\n\nIdentified as: local#opioid",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/LocalSensitiveKindCodes",
                  "code" : "opioid"
                }
              ]
            }
          }
        ],
        "compose" : {
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "425741009"
                },
                {
                  "code" : "5602001"
                },
                {
                  "code" : "145121000119106"
                },
                {
                  "code" : "1149222004"
                },
                {
                  "code" : "56876005"
                },
                {
                  "code" : "60112009"
                },
                {
                  "code" : "61480009"
                },
                {
                  "code" : "266707007"
                },
                {
                  "code" : "52052004"
                },
                {
                  "code" : "6525002"
                }
              ]
            },
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "concept" : [
                {
                  "code" : "352364"
                },
                {
                  "code" : "1049221"
                },
                {
                  "code" : "856987"
                },
                {
                  "code" : "1860154"
                }
              ]
            },
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "concept" : [
                {
                  "code" : "F11.11"
                },
                {
                  "code" : "F11.1"
                }
              ]
            }
          ]
        }
      }
    }
  ]
}

```
