# AB352 ValueSet Bundle - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AB352 ValueSet Bundle**

## Example Bundle: AB352 ValueSet Bundle



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "AB352ValueSetBundle",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://example.org/ValueSet/AB352AbortionTopicsHealthNet",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "AB352AbortionTopicsHealthNet",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_AB352AbortionTopicsHealthNet\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet AB352AbortionTopicsHealthNet</b></p><a name=\"AB352AbortionTopicsHealthNet\"> </a><a name=\"hcAB352AbortionTopicsHealthNet\"> </a><p><b>url</b>: <a href=\"ValueSet-AB352AbortionTopicsHealthNet.html\">Abortion-Related Health Topics (Health Net California)</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: AB352AbortionTopicsHealthNet</p><p><b>title</b>: Abortion-Related Health Topics (Health Net California)</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2023-01-01 00:00:00+0000</p><p><b>description</b>: </p><div><p>Health Net explains and references 500073-Abortion-DX-Code-List.pdf file primarily within its Provider Library and through Provider Bulletins related to legislative compliance. The specific explanation is found in the context of Assembly Bill (AB) 352, which mandates the segregation and protection of sensitive health data.</p>\n<p><strong>Where the Explanation is Located:</strong></p>\n<ol>\n<li>\n<p><strong>Provider Bulletin 24-351 (New Laws Help Safeguard Privacy):</strong> Health Net (and its affiliate Wellcare) issued this bulletin to explain the requirements of AB 352. The bulletin explicitly identifies abortion and abortion-related services as &quot;Sensitive Services&quot; that must be:</p>\n<ul>\n<li>Segregated from the rest of the patient's medical record.</li>\n<li>Excluded from automatic sharing with the California Data Exchange Framework (DxF).</li>\n<li>Protected from out-of-state subpoenas or investigations.</li>\n<li><strong>Reference:</strong> <a href=\"https://providerlibrary.healthnetcalifornia.com/\">Wellcare/Health Net Bulletin 24-351</a></li>\n</ul>\n</li>\n<li>\n<p><strong>Health Net Provider Library - <code>Pregnancy Termination</code> Section:</strong> The website hosts a dedicated page for pregnancy termination benefits. It explains that to comply with California laws (specifically SB 245 for cost-sharing and AB 352 for privacy), providers must use specific diagnosis codes. The 500073 PDF serves as the technical master list for these required codes.</p>\n<ul>\n<li><strong>Reference:</strong> <a href=\"https://providerlibrary.healthnetcalifornia.com/\">Pregnancy Termination - Health Net Provider Library</a></li>\n</ul>\n</li>\n<li>\n<p><strong>The PDF Itself:</strong> The document title, <code>ICD-10-CM Codes for Abortion-Related Services,</code> is the direct label Health Net uses on its search results and directory pages to explain what the file contains. It lists codes ranging from O00 (Ectopic pregnancy) to Z33.2 (Encounter for elective termination).</p>\n</li>\n</ol>\n<p><strong>How Health Net Directs Providers to Use This File:</strong></p>\n<p>According to the site's AB 352 guidance, Health Net recommends that IT and Billing departments download this PDF and use the listed codes to create firewalls in EHR systems. If a patient's record contains any code found in 500073-Abortion-DX-Code-List.pdf, the system should automatically:</p>\n<ul>\n<li>Block that data from being sent to out-of-state entities.</li>\n<li>Prevent the data from being discovered in automated health information exchanges.</li>\n</ul>\n<p><strong>Direct Link to the Document:</strong> <a href=\"https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/500073-Abortion-DX-Code-List.pdf\">500073-Abortion-DX-Code-List.pdf</a></p>\n<p><strong>Note:</strong> This list may not be all-inclusive and is subject to change.</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs ABORTION}\">Abortion-related services</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://hl7.org/fhir/sid/icd-10-cm\">http://hl7.org/fhir/sid/icd-10-cm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: O00.00</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.01</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.101</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.102</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.109</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.111</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.112</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.119</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.201</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.202</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.209</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.211</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.212</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.219</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.80</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.81</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.90</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O00.91</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O01.1</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O01.9</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O02.1</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.0</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.1</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.2</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.30</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.32</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.33</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.34</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.35</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.36</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.37</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.38</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.39</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.4</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.5</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.6</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.7</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.80</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.81</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.82</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.83</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.84</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.85</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.86</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.87</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.88</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.89</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O03.9</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.5</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.6</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.7</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.80</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.81</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.82</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.83</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.84</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.85</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.86</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.87</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.88</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O04.89</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.0</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.1</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.2</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.30</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.31</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.32</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.33</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.34</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.35</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.36</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.37</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.38</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.39</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O07.4</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O08.2</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O08.3</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O08.4</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O08.82</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O08.83</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O08.89</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O20.0</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O20.8</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: O20.9</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Q89.7</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z33.2</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z64.0</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352AbortionTopicsHealthNet",
        "version" : "0.1.0",
        "name" : "AB352AbortionTopicsHealthNet",
        "title" : "Abortion-Related Health Topics (Health Net California)",
        "status" : "active",
        "experimental" : false,
        "date" : "2023-01-01T00:00:00Z",
        "description" : "Health Net explains and references 500073-Abortion-DX-Code-List.pdf file primarily within its Provider Library and through Provider Bulletins related to legislative compliance. The specific explanation is found in the context of Assembly Bill (AB) 352, which mandates the segregation and protection of sensitive health data.\n\n**Where the Explanation is Located:**\n\n1. **Provider Bulletin 24-351 (New Laws Help Safeguard Privacy):** Health Net (and its affiliate Wellcare) issued this bulletin to explain the requirements of AB 352. The bulletin explicitly identifies abortion and abortion-related services as \"Sensitive Services\" that must be:\n   - Segregated from the rest of the patient's medical record.\n   - Excluded from automatic sharing with the California Data Exchange Framework (DxF).\n   - Protected from out-of-state subpoenas or investigations.\n   - **Reference:** [Wellcare/Health Net Bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/)\n\n2. **Health Net Provider Library - `Pregnancy Termination` Section:** The website hosts a dedicated page for pregnancy termination benefits. It explains that to comply with California laws (specifically SB 245 for cost-sharing and AB 352 for privacy), providers must use specific diagnosis codes. The 500073 PDF serves as the technical master list for these required codes.\n   - **Reference:** [Pregnancy Termination - Health Net Provider Library](https://providerlibrary.healthnetcalifornia.com/)\n\n3. **The PDF Itself:** The document title, `ICD-10-CM Codes for Abortion-Related Services,` is the direct label Health Net uses on its search results and directory pages to explain what the file contains. It lists codes ranging from O00 (Ectopic pregnancy) to Z33.2 (Encounter for elective termination).\n\n**How Health Net Directs Providers to Use This File:**\n\nAccording to the site's AB 352 guidance, Health Net recommends that IT and Billing departments download this PDF and use the listed codes to create firewalls in EHR systems. If a patient's record contains any code found in 500073-Abortion-DX-Code-List.pdf, the system should automatically:\n- Block that data from being sent to out-of-state entities.\n- Prevent the data from being discovered in automated health information exchanges.\n\n**Direct Link to the Document:** [500073-Abortion-DX-Code-List.pdf](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/500073-Abortion-DX-Code-List.pdf)\n\n**Note:** This list may not be all-inclusive and is subject to change.",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
                  "code" : "ABORTION"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "concept" : [
                {
                  "code" : "O00.00"
                },
                {
                  "code" : "O00.01"
                },
                {
                  "code" : "O00.101"
                },
                {
                  "code" : "O00.102"
                },
                {
                  "code" : "O00.109"
                },
                {
                  "code" : "O00.111"
                },
                {
                  "code" : "O00.112"
                },
                {
                  "code" : "O00.119"
                },
                {
                  "code" : "O00.201"
                },
                {
                  "code" : "O00.202"
                },
                {
                  "code" : "O00.209"
                },
                {
                  "code" : "O00.211"
                },
                {
                  "code" : "O00.212"
                },
                {
                  "code" : "O00.219"
                },
                {
                  "code" : "O00.80"
                },
                {
                  "code" : "O00.81"
                },
                {
                  "code" : "O00.90"
                },
                {
                  "code" : "O00.91"
                },
                {
                  "code" : "O01.1"
                },
                {
                  "code" : "O01.9"
                },
                {
                  "code" : "O02.1"
                },
                {
                  "code" : "O03.0"
                },
                {
                  "code" : "O03.1"
                },
                {
                  "code" : "O03.2"
                },
                {
                  "code" : "O03.30"
                },
                {
                  "code" : "O03.32"
                },
                {
                  "code" : "O03.33"
                },
                {
                  "code" : "O03.34"
                },
                {
                  "code" : "O03.35"
                },
                {
                  "code" : "O03.36"
                },
                {
                  "code" : "O03.37"
                },
                {
                  "code" : "O03.38"
                },
                {
                  "code" : "O03.39"
                },
                {
                  "code" : "O03.4"
                },
                {
                  "code" : "O03.5"
                },
                {
                  "code" : "O03.6"
                },
                {
                  "code" : "O03.7"
                },
                {
                  "code" : "O03.80"
                },
                {
                  "code" : "O03.81"
                },
                {
                  "code" : "O03.82"
                },
                {
                  "code" : "O03.83"
                },
                {
                  "code" : "O03.84"
                },
                {
                  "code" : "O03.85"
                },
                {
                  "code" : "O03.86"
                },
                {
                  "code" : "O03.87"
                },
                {
                  "code" : "O03.88"
                },
                {
                  "code" : "O03.89"
                },
                {
                  "code" : "O03.9"
                },
                {
                  "code" : "O04.5"
                },
                {
                  "code" : "O04.6"
                },
                {
                  "code" : "O04.7"
                },
                {
                  "code" : "O04.80"
                },
                {
                  "code" : "O04.81"
                },
                {
                  "code" : "O04.82"
                },
                {
                  "code" : "O04.83"
                },
                {
                  "code" : "O04.84"
                },
                {
                  "code" : "O04.85"
                },
                {
                  "code" : "O04.86"
                },
                {
                  "code" : "O04.87"
                },
                {
                  "code" : "O04.88"
                },
                {
                  "code" : "O04.89"
                },
                {
                  "code" : "O07.0"
                },
                {
                  "code" : "O07.1"
                },
                {
                  "code" : "O07.2"
                },
                {
                  "code" : "O07.30"
                },
                {
                  "code" : "O07.31"
                },
                {
                  "code" : "O07.32"
                },
                {
                  "code" : "O07.33"
                },
                {
                  "code" : "O07.34"
                },
                {
                  "code" : "O07.35"
                },
                {
                  "code" : "O07.36"
                },
                {
                  "code" : "O07.37"
                },
                {
                  "code" : "O07.38"
                },
                {
                  "code" : "O07.39"
                },
                {
                  "code" : "O07.4"
                },
                {
                  "code" : "O08.2"
                },
                {
                  "code" : "O08.3"
                },
                {
                  "code" : "O08.4"
                },
                {
                  "code" : "O08.82"
                },
                {
                  "code" : "O08.83"
                },
                {
                  "code" : "O08.89"
                },
                {
                  "code" : "O20.0"
                },
                {
                  "code" : "O20.8"
                },
                {
                  "code" : "O20.9"
                },
                {
                  "code" : "Q89.7"
                },
                {
                  "code" : "Z33.2"
                },
                {
                  "code" : "Z64.0"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://example.org/ValueSet/AB352GenderAffirmingCareHealthNet",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "AB352GenderAffirmingCareHealthNet",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_AB352GenderAffirmingCareHealthNet\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet AB352GenderAffirmingCareHealthNet</b></p><a name=\"AB352GenderAffirmingCareHealthNet\"> </a><a name=\"hcAB352GenderAffirmingCareHealthNet\"> </a><p><b>url</b>: <a href=\"ValueSet-AB352GenderAffirmingCareHealthNet.html\">Gender-Affirming Care Codes (Health Net California)</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: AB352GenderAffirmingCareHealthNet</p><p><b>title</b>: Gender-Affirming Care Codes (Health Net California)</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2024-01-01 00:00:00+0000</p><p><b>description</b>: </p><div><p>CPT and ICD-10-CM codes referenced in Health Net California's clinical policy\n'HNCA.CP.MP.496 - Gender Affirming Procedures'. Intended for segmentation of\ngender-affirming care under AB352.</p>\n<p><strong>Health Net Bulletin 24-351</strong></p>\n<p>Health Net's <a href=\"https://providerlibrary.healthnetcalifornia.com/\">bulletin 24-351</a> explicitly tells providers that services defined in policies like HNCA.CP.MP.496 must be:</p>\n<ul>\n<li><strong>Blocked from automatic sharing</strong> with the California Data Exchange Framework (DxF).</li>\n<li><strong>Omitted from responses</strong> to out-of-state subpoenas or investigations.</li>\n<li><strong>Flagged within the EHR</strong> to prevent unauthorized access by users outside of California.</li>\n</ul>\n<p><strong>Where to Find and Download HNCA.CP.MP.496.pdf</strong> Health Net maintains this policy in several locations within their provider libraries:</p>\n<ul>\n<li><strong>Direct PDF Link:</strong> <a href=\"https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/HNCA.CP.MP.496.pdf\">HNCA.CP.MP.496 - Gender Affirming Procedures</a></li>\n<li><strong>The Provider Library Archive:</strong> You can find this by navigating to Health Net Provider Library &gt; Resources &gt; Clinical Policies and searching for <code>Gender Affirming Procedures</code> or the code <code>496.</code></li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs GENDER_AFFIRMING_CARE}\">Gender-affirming care</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://www.ama-assn.org/go/cpt\">http://www.ama-assn.org/go/cpt</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 11960</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11950</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11951</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11952</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11954</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11970</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 14000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 14001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 14040</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 14041</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15100</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15101</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15120</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15121</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15200</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15570</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15574</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15600</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15620</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15757</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15758</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15775</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15776</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15780</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15781</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15782</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15783</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15786</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15787</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15788</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15789</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15792</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15793</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15820</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15821</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15822</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15823</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15824</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15825</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15826</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15828</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15829</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15830</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15832</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15833</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15834</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15835</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15836</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15837</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15838</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15839</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15876</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15877</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15878</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15879</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 17380</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19300</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19301</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19303</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19316</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19318</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19325</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19350</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21120</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21121</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21122</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21123</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21125</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21127</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21208</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21209</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21210</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 21270</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 30400</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 30410</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 30420</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 30430</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 30435</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 30450</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 31580</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 31587</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 31599</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 31899</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 44145</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53400</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53405</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53410</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53415</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53420</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53425</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53430</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53460</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54125</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54340</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54400</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54401</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54405</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54406</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54408</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54410</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54411</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54415</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54416</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54417</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54520</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54660</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 54690</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 55175</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 55180</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 55970</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 55980</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 56625</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 56800</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 56805</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 56810</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57106</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57107</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57110</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57111</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57291</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57292</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57295</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57296</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57335</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 57426</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58150</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58180</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58260</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58262</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58263</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58267</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58270</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58275</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58280</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58285</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352GenderAffirmingCareHealthNet",
        "version" : "0.1.0",
        "name" : "AB352GenderAffirmingCareHealthNet",
        "title" : "Gender-Affirming Care Codes (Health Net California)",
        "status" : "active",
        "experimental" : false,
        "date" : "2024-01-01T00:00:00Z",
        "description" : "CPT and ICD-10-CM codes referenced in Health Net California's clinical policy\n'HNCA.CP.MP.496 - Gender Affirming Procedures'. Intended for segmentation of\ngender-affirming care under AB352.\n\n**Health Net Bulletin 24-351**\n\nHealth Net's [bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/) explicitly tells providers that services defined in policies like HNCA.CP.MP.496 must be:\n\n- **Blocked from automatic sharing** with the California Data Exchange Framework (DxF).\n- **Omitted from responses** to out-of-state subpoenas or investigations.\n- **Flagged within the EHR** to prevent unauthorized access by users outside of California.\n\n**Where to Find and Download HNCA.CP.MP.496.pdf** Health Net maintains this policy in several locations within their provider libraries:\n\n- **Direct PDF Link:** [HNCA.CP.MP.496 - Gender Affirming Procedures](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/HNCA.CP.MP.496.pdf)\n- **The Provider Library Archive:** You can find this by navigating to Health Net Provider Library > Resources > Clinical Policies and searching for `Gender Affirming Procedures` or the code `496.`",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
                  "code" : "GENDER_AFFIRMING_CARE"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "concept" : [
                {
                  "code" : "11960"
                },
                {
                  "code" : "11950"
                },
                {
                  "code" : "11951"
                },
                {
                  "code" : "11952"
                },
                {
                  "code" : "11954"
                },
                {
                  "code" : "11970"
                },
                {
                  "code" : "14000"
                },
                {
                  "code" : "14001"
                },
                {
                  "code" : "14040"
                },
                {
                  "code" : "14041"
                },
                {
                  "code" : "15100"
                },
                {
                  "code" : "15101"
                },
                {
                  "code" : "15120"
                },
                {
                  "code" : "15121"
                },
                {
                  "code" : "15200"
                },
                {
                  "code" : "15570"
                },
                {
                  "code" : "15574"
                },
                {
                  "code" : "15600"
                },
                {
                  "code" : "15620"
                },
                {
                  "code" : "15757"
                },
                {
                  "code" : "15758"
                },
                {
                  "code" : "15775"
                },
                {
                  "code" : "15776"
                },
                {
                  "code" : "15780"
                },
                {
                  "code" : "15781"
                },
                {
                  "code" : "15782"
                },
                {
                  "code" : "15783"
                },
                {
                  "code" : "15786"
                },
                {
                  "code" : "15787"
                },
                {
                  "code" : "15788"
                },
                {
                  "code" : "15789"
                },
                {
                  "code" : "15792"
                },
                {
                  "code" : "15793"
                },
                {
                  "code" : "15820"
                },
                {
                  "code" : "15821"
                },
                {
                  "code" : "15822"
                },
                {
                  "code" : "15823"
                },
                {
                  "code" : "15824"
                },
                {
                  "code" : "15825"
                },
                {
                  "code" : "15826"
                },
                {
                  "code" : "15828"
                },
                {
                  "code" : "15829"
                },
                {
                  "code" : "15830"
                },
                {
                  "code" : "15832"
                },
                {
                  "code" : "15833"
                },
                {
                  "code" : "15834"
                },
                {
                  "code" : "15835"
                },
                {
                  "code" : "15836"
                },
                {
                  "code" : "15837"
                },
                {
                  "code" : "15838"
                },
                {
                  "code" : "15839"
                },
                {
                  "code" : "15876"
                },
                {
                  "code" : "15877"
                },
                {
                  "code" : "15878"
                },
                {
                  "code" : "15879"
                },
                {
                  "code" : "17380"
                },
                {
                  "code" : "19300"
                },
                {
                  "code" : "19301"
                },
                {
                  "code" : "19303"
                },
                {
                  "code" : "19316"
                },
                {
                  "code" : "19318"
                },
                {
                  "code" : "19325"
                },
                {
                  "code" : "19350"
                },
                {
                  "code" : "21120"
                },
                {
                  "code" : "21121"
                },
                {
                  "code" : "21122"
                },
                {
                  "code" : "21123"
                },
                {
                  "code" : "21125"
                },
                {
                  "code" : "21127"
                },
                {
                  "code" : "21208"
                },
                {
                  "code" : "21209"
                },
                {
                  "code" : "21210"
                },
                {
                  "code" : "21270"
                },
                {
                  "code" : "30400"
                },
                {
                  "code" : "30410"
                },
                {
                  "code" : "30420"
                },
                {
                  "code" : "30430"
                },
                {
                  "code" : "30435"
                },
                {
                  "code" : "30450"
                },
                {
                  "code" : "31580"
                },
                {
                  "code" : "31587"
                },
                {
                  "code" : "31599"
                },
                {
                  "code" : "31899"
                },
                {
                  "code" : "44145"
                },
                {
                  "code" : "53400"
                },
                {
                  "code" : "53405"
                },
                {
                  "code" : "53410"
                },
                {
                  "code" : "53415"
                },
                {
                  "code" : "53420"
                },
                {
                  "code" : "53425"
                },
                {
                  "code" : "53430"
                },
                {
                  "code" : "53460"
                },
                {
                  "code" : "54125"
                },
                {
                  "code" : "54340"
                },
                {
                  "code" : "54400"
                },
                {
                  "code" : "54401"
                },
                {
                  "code" : "54405"
                },
                {
                  "code" : "54406"
                },
                {
                  "code" : "54408"
                },
                {
                  "code" : "54410"
                },
                {
                  "code" : "54411"
                },
                {
                  "code" : "54415"
                },
                {
                  "code" : "54416"
                },
                {
                  "code" : "54417"
                },
                {
                  "code" : "54520"
                },
                {
                  "code" : "54660"
                },
                {
                  "code" : "54690"
                },
                {
                  "code" : "55175"
                },
                {
                  "code" : "55180"
                },
                {
                  "code" : "55970"
                },
                {
                  "code" : "55980"
                },
                {
                  "code" : "56625"
                },
                {
                  "code" : "56800"
                },
                {
                  "code" : "56805"
                },
                {
                  "code" : "56810"
                },
                {
                  "code" : "57106"
                },
                {
                  "code" : "57107"
                },
                {
                  "code" : "57110"
                },
                {
                  "code" : "57111"
                },
                {
                  "code" : "57291"
                },
                {
                  "code" : "57292"
                },
                {
                  "code" : "57295"
                },
                {
                  "code" : "57296"
                },
                {
                  "code" : "57335"
                },
                {
                  "code" : "57426"
                },
                {
                  "code" : "58150"
                },
                {
                  "code" : "58180"
                },
                {
                  "code" : "58260"
                },
                {
                  "code" : "58262"
                },
                {
                  "code" : "58263"
                },
                {
                  "code" : "58267"
                },
                {
                  "code" : "58270"
                },
                {
                  "code" : "58275"
                },
                {
                  "code" : "58280"
                },
                {
                  "code" : "58285"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://example.org/ValueSet/AB352ContraceptionTopicsAi",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "AB352ContraceptionTopicsAi",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_AB352ContraceptionTopicsAi\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet AB352ContraceptionTopicsAi</b></p><a name=\"AB352ContraceptionTopicsAi\"> </a><a name=\"hcAB352ContraceptionTopicsAi\"> </a><p><b>url</b>: <a href=\"ValueSet-AB352ContraceptionTopicsAi.html\">Contraception-Related Health Topics</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: AB352ContraceptionTopicsAi</p><p><b>title</b>: Contraception-Related Health Topics</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2026-01-23 00:00:00+0000</p><p><b>description</b>: </p><div><p>Clinical concepts related to contraception drawn from LOINC, SNOMED CT, and ICD-10-CM.\nIntended for segmentation of sensitive reproductive health information under AB352.</p>\n<p>This ValueSet does not include code recommendations from Health Net California. Health Net California does not have a single source document for contraception-related codes similar to their abortion-related code list. Instead, Health Net references multiple sources, including the DHCS Family PACT Code List, within various policy documents.</p>\n<ul>\n<li><strong>Health Net Bulletin 24-351:</strong> New Laws Help Safeguard Privacy (<a href=\"https://providerlibrary.healthnetcalifornia.com/\">View Link</a>)</li>\n<li><strong>Health Net Medi-Cal Provider Manual (Chapter 4):</strong> Sensitive Services section (<a href=\"https://providerlibrary.healthnetcalifornia.com/\">Link to Manuals</a>)</li>\n<li><strong>Family PACT Policies:</strong> Health Net adopts the DHCS Family PACT Code List as their baseline for identifying what constitutes a contraceptive service.</li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs CONTRACEPTION}\">Contraception</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://loinc.org/\">http://loinc.org</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 8663-7</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 8664-5</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 169745008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 386761002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 304527002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 169472004</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://hl7.org/fhir/sid/icd-10-cm\">http://hl7.org/fhir/sid/icd-10-cm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.011</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.012</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.013</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.014</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.015</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.016</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.017</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.018</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.019</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.2</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.430</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.431</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.432</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.8</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: Z30.9</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"http://www.ama-assn.org/go/cpt\">http://www.ama-assn.org/go/cpt</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 11981</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11982</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11983</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58300</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58301</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58600</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58611</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58615</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58670</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 58671</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 55250</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 99401</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 99402</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 99403</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 99404</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352ContraceptionTopicsAi",
        "version" : "0.1.0",
        "name" : "AB352ContraceptionTopicsAi",
        "title" : "Contraception-Related Health Topics",
        "status" : "active",
        "experimental" : false,
        "date" : "2026-01-23T00:00:00Z",
        "description" : "Clinical concepts related to contraception drawn from LOINC, SNOMED CT, and ICD-10-CM.\nIntended for segmentation of sensitive reproductive health information under AB352.\n\nThis ValueSet does not include code recommendations from Health Net California. Health Net California does not have a single source document for contraception-related codes similar to their abortion-related code list. Instead, Health Net references multiple sources, including the DHCS Family PACT Code List, within various policy documents.\n\n- **Health Net Bulletin 24-351:** New Laws Help Safeguard Privacy ([View Link](https://providerlibrary.healthnetcalifornia.com/))\n- **Health Net Medi-Cal Provider Manual (Chapter 4):** Sensitive Services section ([Link to Manuals](https://providerlibrary.healthnetcalifornia.com/))\n- **Family PACT Policies:** Health Net adopts the DHCS Family PACT Code List as their baseline for identifying what constitutes a contraceptive service.",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
                  "code" : "CONTRACEPTION"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://loinc.org",
              "concept" : [
                {
                  "code" : "8663-7"
                },
                {
                  "code" : "8664-5"
                }
              ]
            },
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "169745008"
                },
                {
                  "code" : "386761002"
                },
                {
                  "code" : "304527002"
                },
                {
                  "code" : "169472004"
                }
              ]
            },
            {
              "system" : "http://hl7.org/fhir/sid/icd-10-cm",
              "concept" : [
                {
                  "code" : "Z30.011"
                },
                {
                  "code" : "Z30.012"
                },
                {
                  "code" : "Z30.013"
                },
                {
                  "code" : "Z30.014"
                },
                {
                  "code" : "Z30.015"
                },
                {
                  "code" : "Z30.016"
                },
                {
                  "code" : "Z30.017"
                },
                {
                  "code" : "Z30.018"
                },
                {
                  "code" : "Z30.019"
                },
                {
                  "code" : "Z30.2"
                },
                {
                  "code" : "Z30.430"
                },
                {
                  "code" : "Z30.431"
                },
                {
                  "code" : "Z30.432"
                },
                {
                  "code" : "Z30.8"
                },
                {
                  "code" : "Z30.9"
                }
              ]
            },
            {
              "system" : "http://www.ama-assn.org/go/cpt",
              "concept" : [
                {
                  "code" : "11981"
                },
                {
                  "code" : "11982"
                },
                {
                  "code" : "11983"
                },
                {
                  "code" : "58300"
                },
                {
                  "code" : "58301"
                },
                {
                  "code" : "58600"
                },
                {
                  "code" : "58611"
                },
                {
                  "code" : "58615"
                },
                {
                  "code" : "58670"
                },
                {
                  "code" : "58671"
                },
                {
                  "code" : "55250"
                },
                {
                  "code" : "99401"
                },
                {
                  "code" : "99402"
                },
                {
                  "code" : "99403"
                },
                {
                  "code" : "99404"
                }
              ]
            }
          ]
        }
      }
    }
  ]
}

```
