# About and Download - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **About and Download**

## About and Download

You can download:

* [this entire guide](full-ig.zip),
* the definition resources in [json](definitions.json.zip), [xml](definitions.xml.zip), [ttl](definitions.ttl.zip), or [csv](csvs.zip) format, or
* the example resources in [json](examples.json.zip), [xml](examples.xml.zip) or [ttl](examples.ttl.zip) format.

The source code for this Implementation Guide can be found on [SHIFT Task Force Github Repo](https://github.com/SHIFT-Task-Force).

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (SHIFT-Task-Force.slsValueSets.r4)](package.r4.tgz) and [R4B (SHIFT-Task-Force.slsValueSets.r4b)](package.r4b.tgz) are available.

#### Dependency Table



#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* LOINC: [AB352ContraceptionTopicsAi](ValueSet-AB352ContraceptionTopicsAi.md), [Consent/Consent-AB352-Example](Consent-Consent-AB352-Example.md)... Show 6 more, [Consent/Consent-AB352-Example-AllowAll](Consent-Consent-AB352-Example-AllowAll.md), [Consent/Consent-AB352-Example2](Consent-Consent-AB352-Example2.md), [Consent/Consent-AB352-Example4](Consent-Consent-AB352-Example4.md), [LeapSlsBehavioralHealthCodes](ValueSet-LeapSlsBehavioralHealthCodes.md), [SyntheaDementiaVS](ValueSet-SyntheaDementiaVS.md) and [SyntheaOpioidAddictionVS](ValueSet-SyntheaOpioidAddictionVS.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AB352ContraceptionTopicsAi](ValueSet-AB352ContraceptionTopicsAi.md), [LeapSlsBehavioralHealthCodes](ValueSet-LeapSlsBehavioralHealthCodes.md)... Show 11 more, [LeapSlsHallucinogenCodes](ValueSet-LeapSlsHallucinogenCodes.md), [LeapSlsOpioidCodes](ValueSet-LeapSlsOpioidCodes.md), [LeapSlsSubstanceUseCodes](ValueSet-LeapSlsSubstanceUseCodes.md), [SyntheaAttentionDeficitDisorderVS](ValueSet-SyntheaAttentionDeficitDisorderVS.md), [SyntheaCerebralPalsyVS](ValueSet-SyntheaCerebralPalsyVS.md), [SyntheaCysticFibrosisVS](ValueSet-SyntheaCysticFibrosisVS.md), [SyntheaDementiaVS](ValueSet-SyntheaDementiaVS.md), [SyntheaOpioidAddictionVS](ValueSet-SyntheaOpioidAddictionVS.md), [SyntheaPregnancyVS](ValueSet-SyntheaPregnancyVS.md), [SyntheaSelfHarmVS](ValueSet-SyntheaSelfHarmVS.md) and [SyntheaSpinaBifidaVS](ValueSet-SyntheaSpinaBifidaVS.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Consent Scope Codes](http://terminology.hl7.org/7.0.1/CodeSystem-consentscope.html): [Consent/Consent-AB352-Example](Consent-Consent-AB352-Example.md), [Consent/Consent-AB352-Example-AllowAll](Consent-Consent-AB352-Example-AllowAll.md), [Consent/Consent-AB352-Example2](Consent-Consent-AB352-Example2.md) and [Consent/Consent-AB352-Example4](Consent-Consent-AB352-Example4.md)
* [Provenance participant type](http://terminology.hl7.org/7.0.1/CodeSystem-provenance-participant-type.html): [Provenance/SamhsaSensitive-initial-history](Provenance-SamhsaSensitive-initial-history.md), [Provenance/SamhsaSensitive-split-history](Provenance-SamhsaSensitive-split-history.md) and [Provenance/SamhsaSensitive-update-history](Provenance-SamhsaSensitive-update-history.md)
* [UsageContextType](http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html): [AB352AbortionTopicsHealthNet](ValueSet-AB352AbortionTopicsHealthNet.md), [AB352ContraceptionTopicsAi](ValueSet-AB352ContraceptionTopicsAi.md)... Show 30 more, [AB352GenderAffirmingCareHealthNet](ValueSet-AB352GenderAffirmingCareHealthNet.md), [Bundle/AB352ValueSetBundle](Bundle-AB352ValueSetBundle.md), [Bundle/LeapSlsBundledSensitiveKindCodes](Bundle-LeapSlsBundledSensitiveKindCodes.md), [Bundle/SamhsaSensitiveBundle](Bundle-SamhsaSensitiveBundle.md), [Bundle/SyntheaSensitiveValueSetsBundle](Bundle-SyntheaSensitiveValueSetsBundle.md), [LeapSlsBehavioralHealthCodes](ValueSet-LeapSlsBehavioralHealthCodes.md), [LeapSlsHallucinogenCodes](ValueSet-LeapSlsHallucinogenCodes.md), [LeapSlsOpioidCodes](ValueSet-LeapSlsOpioidCodes.md), [LeapSlsSexualityAndReproductiveHealthCodes](ValueSet-LeapSlsSexualityAndReproductiveHealthCodes.md), [LeapSlsSubstanceUseCodes](ValueSet-LeapSlsSubstanceUseCodes.md), [SamhsaSensitiveETH](ValueSet-SamhsaSensitiveETH.md), [SamhsaSensitiveETHJustRx](ValueSet-SamhsaSensitiveETHJustRx.md), [SamhsaSensitiveETHUD](ValueSet-SamhsaSensitiveETHUD.md), [SamhsaSensitiveHIV](ValueSet-SamhsaSensitiveHIV.md), [SamhsaSensitiveOPIOIDUD](ValueSet-SamhsaSensitiveOPIOIDUD.md), [SamhsaSensitivePSY](ValueSet-SamhsaSensitivePSY.md), [SamhsaSensitiveSDV](ValueSet-SamhsaSensitiveSDV.md), [SyntheaAttentionDeficitDisorderVS](ValueSet-SyntheaAttentionDeficitDisorderVS.md), [SyntheaCerebralPalsyVS](ValueSet-SyntheaCerebralPalsyVS.md), [SyntheaCognitiveVS](ValueSet-SyntheaCognitiveVS.md), [SyntheaCysticFibrosisVS](ValueSet-SyntheaCysticFibrosisVS.md), [SyntheaDementiaVS](ValueSet-SyntheaDementiaVS.md), [SyntheaGeneticVS](ValueSet-SyntheaGeneticVS.md), [SyntheaMentalBehavioralHealthVS](ValueSet-SyntheaMentalBehavioralHealthVS.md), [SyntheaOpioidAddictionVS](ValueSet-SyntheaOpioidAddictionVS.md), [SyntheaPregnancyVS](ValueSet-SyntheaPregnancyVS.md), [SyntheaReproductiveHealthVS](ValueSet-SyntheaReproductiveHealthVS.md), [SyntheaSelfHarmVS](ValueSet-SyntheaSelfHarmVS.md), [SyntheaSpinaBifidaVS](ValueSet-SyntheaSpinaBifidaVS.md) and [SyntheaSubstanceAbuseVS](ValueSet-SyntheaSubstanceAbuseVS.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Bundle/LeapSlsBundledSensitiveKindCodes](Bundle-LeapSlsBundledSensitiveKindCodes.md), [Bundle/SamhsaSensitiveBundle](Bundle-SamhsaSensitiveBundle.md)... Show 24 more, [Bundle/SyntheaSensitiveValueSetsBundle](Bundle-SyntheaSensitiveValueSetsBundle.md), [LeapSlsBehavioralHealthCodes](ValueSet-LeapSlsBehavioralHealthCodes.md), [LeapSlsSexualityAndReproductiveHealthCodes](ValueSet-LeapSlsSexualityAndReproductiveHealthCodes.md), [LeapSlsSubstanceUseCodes](ValueSet-LeapSlsSubstanceUseCodes.md), [SamhsaSensitiveETH](ValueSet-SamhsaSensitiveETH.md), [SamhsaSensitiveETHJustRx](ValueSet-SamhsaSensitiveETHJustRx.md), [SamhsaSensitiveETHUD](ValueSet-SamhsaSensitiveETHUD.md), [SamhsaSensitiveHIV](ValueSet-SamhsaSensitiveHIV.md), [SamhsaSensitiveOPIOIDUD](ValueSet-SamhsaSensitiveOPIOIDUD.md), [SamhsaSensitivePSY](ValueSet-SamhsaSensitivePSY.md), [SamhsaSensitiveSDV](ValueSet-SamhsaSensitiveSDV.md), [SyntheaAttentionDeficitDisorderVS](ValueSet-SyntheaAttentionDeficitDisorderVS.md), [SyntheaCerebralPalsyVS](ValueSet-SyntheaCerebralPalsyVS.md), [SyntheaCognitiveVS](ValueSet-SyntheaCognitiveVS.md), [SyntheaCysticFibrosisVS](ValueSet-SyntheaCysticFibrosisVS.md), [SyntheaDementiaVS](ValueSet-SyntheaDementiaVS.md), [SyntheaGeneticVS](ValueSet-SyntheaGeneticVS.md), [SyntheaMentalBehavioralHealthVS](ValueSet-SyntheaMentalBehavioralHealthVS.md), [SyntheaOpioidAddictionVS](ValueSet-SyntheaOpioidAddictionVS.md), [SyntheaPregnancyVS](ValueSet-SyntheaPregnancyVS.md), [SyntheaReproductiveHealthVS](ValueSet-SyntheaReproductiveHealthVS.md), [SyntheaSelfHarmVS](ValueSet-SyntheaSelfHarmVS.md), [SyntheaSpinaBifidaVS](ValueSet-SyntheaSpinaBifidaVS.md) and [SyntheaSubstanceAbuseVS](ValueSet-SyntheaSubstanceAbuseVS.md)
* [ActReason](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html): [Consent/Consent-AB352-Example](Consent-Consent-AB352-Example.md), [Consent/Consent-AB352-Example-AllowAll](Consent-Consent-AB352-Example-AllowAll.md)... Show 5 more, [Consent/Consent-AB352-Example2](Consent-Consent-AB352-Example2.md), [Consent/Consent-AB352-Example4](Consent-Consent-AB352-Example4.md), [Provenance/SamhsaSensitive-initial-history](Provenance-SamhsaSensitive-initial-history.md), [Provenance/SamhsaSensitive-split-history](Provenance-SamhsaSensitive-split-history.md) and [Provenance/SamhsaSensitive-update-history](Provenance-SamhsaSensitive-update-history.md)
* [Confidentiality](http://terminology.hl7.org/7.0.1/CodeSystem-v3-Confidentiality.html): [Consent/Consent-AB352-Example](Consent-Consent-AB352-Example.md), [Consent/Consent-AB352-Example-AllowAll](Consent-Consent-AB352-Example-AllowAll.md) and [Consent/Consent-AB352-Example2](Consent-Consent-AB352-Example2.md)
* [DataOperation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-DataOperation.html): [Provenance/SamhsaSensitive-initial-history](Provenance-SamhsaSensitive-initial-history.md), [Provenance/SamhsaSensitive-split-history](Provenance-SamhsaSensitive-split-history.md) and [Provenance/SamhsaSensitive-update-history](Provenance-SamhsaSensitive-update-history.md)


