# Synthea Codes for attention_deficit_disorder - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for attention_deficit_disorder**

## ValueSet: Synthea Codes for attention_deficit_disorder 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaAttentionDeficitDisorderVS | *Version*:0.1.0 |
| Active as of 2026-02-04 | *Computable Name*:SyntheaAttentionDeficitDisorderVS |
| **Usage:**Clinical Focus: psychiatry disorder information sensitivity | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: attention_deficit_disorder. 

 **References** 

* Included into [SyntheaMentalBehavioralHealthVS](ValueSet-SyntheaMentalBehavioralHealthVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaAttentionDeficitDisorderVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaAttentionDeficitDisorderVS",
  "version" : "0.1.0",
  "name" : "SyntheaAttentionDeficitDisorderVS",
  "title" : "Synthea Codes for attention_deficit_disorder",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-04T23:32:52+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: attention_deficit_disorder.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "PSY",
            "display" : "psychiatry disorder information sensitivity"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "192127007"
          },
          {
            "code" : "185347001"
          },
          {
            "code" : "386522008"
          },
          {
            "code" : "228557008"
          }
        ]
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "concept" : [
          {
            "code" : "1091392"
          },
          {
            "code" : "608139"
          }
        ]
      }
    ]
  }
}

```
