# ValueSet - Example Behavioral Health Codes - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ValueSet - Example Behavioral Health Codes**

## ValueSet: ValueSet - Example Behavioral Health Codes 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsBehavioralHealthCodes | *Version*:0.1.0 |
| Active as of 2026-02-04 | *Computable Name*:LeapSlsBehavioralHealthCodes |
| **Usage:**Clinical Focus: behavioral health information sensitivity | |

 
Example set of codes representing behavioral health conditions requiring special privacy protections 
Identified as: v3-ActCode#BH 

 **References** 

* Included into [LeapSlsSensitiveCodes](ValueSet-LeapSlsSensitiveCodes.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "LeapSlsBehavioralHealthCodes",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsBehavioralHealthCodes",
  "version" : "0.1.0",
  "name" : "LeapSlsBehavioralHealthCodes",
  "title" : "ValueSet - Example Behavioral Health Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-04T23:32:52+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Example set of codes representing behavioral health conditions requiring special privacy protections\n\nIdentified as: v3-ActCode#BH",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "BH",
            "display" : "behavioral health information sensitivity"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/LeapSlsHallucinogenCodes"
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "720433000"
          }
        ]
      },
      {
        "system" : "http://www.ama-assn.org/go/cpt",
        "concept" : [
          {
            "code" : "96127"
          }
        ]
      },
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "44249-1"
          },
          {
            "code" : "89204-2"
          }
        ]
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "concept" : [
          {
            "code" : "315952"
          },
          {
            "code" : "352364"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "372767007"
          },
          {
            "code" : "310496002"
          },
          {
            "code" : "1376001"
          },
          {
            "code" : "5602001"
          },
          {
            "code" : "444175001"
          }
        ]
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "concept" : [
          {
            "code" : "F33.1"
          },
          {
            "code" : "F60.5"
          },
          {
            "code" : "F11.11"
          }
        ]
      }
    ]
  }
}

```
