# Contraception-Related Health Topics - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Contraception-Related Health Topics**

## ValueSet: Contraception-Related Health Topics 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352ContraceptionTopicsAi | *Version*:0.1.0 |
| Active as of 2026-01-23 | *Computable Name*:AB352ContraceptionTopicsAi |
| **Usage:**Clinical Focus: Contraception | |

 
Clinical concepts related to contraception drawn from LOINC, SNOMED CT, and ICD-10-CM. Intended for segmentation of sensitive reproductive health information under AB352. 
This ValueSet does not include code recommendations from Health Net California. Health Net California does not have a single source document for contraception-related codes similar to their abortion-related code list. Instead, Health Net references multiple sources, including the DHCS Family PACT Code List, within various policy documents. 
* **Health Net Bulletin 24-351:** New Laws Help Safeguard Privacy ([View Link](https://providerlibrary.healthnetcalifornia.com/))
* **Health Net Medi-Cal Provider Manual (Chapter 4):** Sensitive Services section ([Link to Manuals](https://providerlibrary.healthnetcalifornia.com/))
* **Family PACT Policies:** Health Net adopts the DHCS Family PACT Code List as their baseline for identifying what constitutes a contraceptive service.
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "AB352ContraceptionTopicsAi",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352ContraceptionTopicsAi",
  "version" : "0.1.0",
  "name" : "AB352ContraceptionTopicsAi",
  "title" : "Contraception-Related Health Topics",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-01-23T00:00:00Z",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Clinical concepts related to contraception drawn from LOINC, SNOMED CT, and ICD-10-CM.\nIntended for segmentation of sensitive reproductive health information under AB352.\n\nThis ValueSet does not include code recommendations from Health Net California. Health Net California does not have a single source document for contraception-related codes similar to their abortion-related code list. Instead, Health Net references multiple sources, including the DHCS Family PACT Code List, within various policy documents.\n\n- **Health Net Bulletin 24-351:** New Laws Help Safeguard Privacy ([View Link](https://providerlibrary.healthnetcalifornia.com/))\n- **Health Net Medi-Cal Provider Manual (Chapter 4):** Sensitive Services section ([Link to Manuals](https://providerlibrary.healthnetcalifornia.com/))\n- **Family PACT Policies:** Health Net adopts the DHCS Family PACT Code List as their baseline for identifying what constitutes a contraceptive service.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
            "code" : "CONTRACEPTION"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "8663-7"
          },
          {
            "code" : "8664-5"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "169745008"
          },
          {
            "code" : "386761002"
          },
          {
            "code" : "304527002"
          },
          {
            "code" : "169472004"
          }
        ]
      },
      {
        "system" : "http://hl7.org/fhir/sid/icd-10-cm",
        "concept" : [
          {
            "code" : "Z30.011"
          },
          {
            "code" : "Z30.012"
          },
          {
            "code" : "Z30.013"
          },
          {
            "code" : "Z30.014"
          },
          {
            "code" : "Z30.015"
          },
          {
            "code" : "Z30.016"
          },
          {
            "code" : "Z30.017"
          },
          {
            "code" : "Z30.018"
          },
          {
            "code" : "Z30.019"
          },
          {
            "code" : "Z30.2"
          },
          {
            "code" : "Z30.430"
          },
          {
            "code" : "Z30.431"
          },
          {
            "code" : "Z30.432"
          },
          {
            "code" : "Z30.8"
          },
          {
            "code" : "Z30.9"
          }
        ]
      },
      {
        "system" : "http://www.ama-assn.org/go/cpt",
        "concept" : [
          {
            "code" : "11981"
          },
          {
            "code" : "11982"
          },
          {
            "code" : "11983"
          },
          {
            "code" : "58300"
          },
          {
            "code" : "58301"
          },
          {
            "code" : "58600"
          },
          {
            "code" : "58611"
          },
          {
            "code" : "58615"
          },
          {
            "code" : "58670"
          },
          {
            "code" : "58671"
          },
          {
            "code" : "55250"
          },
          {
            "code" : "99401"
          },
          {
            "code" : "99402"
          },
          {
            "code" : "99403"
          },
          {
            "code" : "99404"
          }
        ]
      }
    ]
  }
}

```
