# AB352 Organizational Privacy Consent - depth - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **AB352 Organizational Privacy Consent - depth**

## Example Consent: AB352 Organizational Privacy Consent - depth

**status**: Active

**scope**: Privacy Consent

**category**: Release of information consent

**patient**: [http://example.org/Patient/example](http://example.org/Patient/example)

**dateTime**: 2025-01-15 12:00:00+0000

**organization**: [Example California Hospital](http://example.org/Organization/ca-hospital)

**policyRule**: California AB 352

> **provision****type**: Opt In**securityLabel**: [Confidentiality: N](http://terminology.hl7.org/7.0.1/CodeSystem-v3-Confidentiality.html#v3-Confidentiality-N) (Normal)**purpose**: [ActReason: TREAT](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html#v3-ActReason-TREAT) (treatment), [ActReason: HPAYMT](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html#v3-ActReason-HPAYMT) (healthcare payment), [ActReason: HOPERAT](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActReason.html#v3-ActReason-HOPERAT) (healthcare operations)
> **provision****type**: Opt Out**securityLabel**: [Health Information Sensitivity Categories: ABORTION](CodeSystem-AB352HealthSensitivityCs.md#AB352HealthSensitivityCs-ABORTION) (Abortion-related services), [Health Information Sensitivity Categories: GENDER_AFFIRMING_CARE](CodeSystem-AB352HealthSensitivityCs.md#AB352HealthSensitivityCs-GENDER_AFFIRMING_CARE) (Gender-affirming care), [Health Information Sensitivity Categories: CONTRACEPTION](CodeSystem-AB352HealthSensitivityCs.md#AB352HealthSensitivityCs-CONTRACEPTION) (Contraception)

### Provisions

| | | |
| :--- | :--- | :--- |
| - | **Extension** | **Type** |
| * |  | Opt In |





## Resource Content

```json
{
  "resourceType" : "Consent",
  "id" : "Consent-AB352-Example",
  "status" : "active",
  "scope" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
        "code" : "patient-privacy",
        "display" : "Privacy Consent"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "64292-6",
          "display" : "Release of information consent"
        }
      ]
    }
  ],
  "patient" : {
    "reference" : "http://example.org/Patient/example"
  },
  "dateTime" : "2025-01-15T12:00:00Z",
  "organization" : [
    {
      "reference" : "http://example.org/Organization/ca-hospital",
      "display" : "Example California Hospital"
    }
  ],
  "policyRule" : {
    "coding" : [
      {
        "system" : "urn:ietf:rfc:3986",
        "code" : "urn:law:us:ca:statute:AB352",
        "display" : "California AB 352"
      }
    ]
  },
  "provision" : {
    "type" : "permit",
    "securityLabel" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-Confidentiality",
        "code" : "N",
        "display" : "Normal"
      }
    ],
    "purpose" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "TREAT"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HPAYMT"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-ActReason",
        "code" : "HOPERAT"
      }
    ],
    "provision" : [
      {
        "type" : "deny",
        "securityLabel" : [
          {
            "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
            "code" : "ABORTION"
          },
          {
            "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
            "code" : "GENDER_AFFIRMING_CARE"
          },
          {
            "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
            "code" : "CONTRACEPTION"
          }
        ],
        "provision" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/consent-location",
                "valueReference" : {
                  "reference" : "Location/ca-location"
                }
              }
            ],
            "type" : "permit"
          }
        ]
      }
    ]
  }
}

```
