# SHIFT-Task-Force.slsValueSets#0.1.0: SHIFT SLS ValueSets Implementation Guide

## Pages

* [SHIFT IG Home](index.md)
* [Security Labeling Services (SLS)](sls.md)
* [California AB352 Use Case](ab352.md)
* [Synthea Modules Used](synthea.md)
* [Artifacts Summary](artifacts.md)
* [About and Download](download.md)

## Resources

### CodeSystems

* [Health Information Sensitivity Categories](CodeSystem-AB352HealthSensitivityCs.md)

### ValueSets

* [Abortion-Related Health Topics (Health Net California)](ValueSet-AB352AbortionTopicsHealthNet.md)
* [Contraception-Related Health Topics](ValueSet-AB352ContraceptionTopicsAi.md)
* [Gender-Affirming Care Codes (Health Net California)](ValueSet-AB352GenderAffirmingCareHealthNet.md)
* [AB352 Segmentation Tags](ValueSet-AB352SegmentationTags.md)
* [ValueSet - Leap SLS Behavioral Health Codes](ValueSet-LeapSlsBehavioralHealthCodes.md)
* [ValueSet - Leap SLS Hallucinogen Codes](ValueSet-LeapSlsHallucinogenCodes.md)
* [ValueSet - Leap SLS Opioid Codes](ValueSet-LeapSlsOpioidCodes.md)
* [ValueSet - Leap SLS Psychiatric Notes Use Codes](ValueSet-LeapSlsPsychiatricNotesCodes.md)
* [ValueSet - Leap SLS Sensitive Kind Codes](ValueSet-LeapSlsSensitiveCodes.md)
* [ValueSet - Leap SLS Sexuality and Reproductive Health Codes](ValueSet-LeapSlsSexualityAndReproductiveHealthCodes.md)
* [clinical codes that indicate ETH](ValueSet-SamhsaSensitiveETH.md)
* [clinical codes that indicate ETH](ValueSet-SamhsaSensitiveETHJustRx.md)
* [clinical codes that indicate ETHUD](ValueSet-SamhsaSensitiveETHUD.md)
* [clinical codes that indicate HIV](ValueSet-SamhsaSensitiveHIV.md)
* [clinical codes that indicate OPIOIDUD](ValueSet-SamhsaSensitiveOPIOIDUD.md)
* [clinical codes that indicate PSY](ValueSet-SamhsaSensitivePSY.md)
* [clinical codes that indicate SDV](ValueSet-SamhsaSensitiveSDV.md)
* [Synthea Codes for attention_deficit_disorder](ValueSet-SyntheaAttentionDeficitDisorderVS.md)
* [Synthea Codes for cerebral_palsy](ValueSet-SyntheaCerebralPalsyVS.md)
* [Synthea Cognitive Disability Codes](ValueSet-SyntheaCognitiveVS.md)
* [Synthea Codes for cystic_fibrosis](ValueSet-SyntheaCysticFibrosisVS.md)
* [Synthea Codes for dementia](ValueSet-SyntheaDementiaVS.md)
* [Synthea Genetic Disability Codes](ValueSet-SyntheaGeneticVS.md)
* [Synthea Mental and Behavioral Health Codes](ValueSet-SyntheaMentalBehavioralHealthVS.md)
* [Synthea Codes for opioid_addiction](ValueSet-SyntheaOpioidAddictionVS.md)
* [Synthea Codes for pregnancy](ValueSet-SyntheaPregnancyVS.md)
* [Synthea Reproductive Health Codes](ValueSet-SyntheaReproductiveHealthVS.md)
* [Synthea Codes for self_harm](ValueSet-SyntheaSelfHarmVS.md)
* [Synthea Codes for spina_bifida](ValueSet-SyntheaSpinaBifidaVS.md)
* [Synthea Substance Abuse Codes](ValueSet-SyntheaSubstanceAbuseVS.md)

### ImplementationGuides

* [SHIFT SLS ValueSets Implementation Guide](index.md)

### Provenances

* [SamhsaSensitive-initial-history](Provenance-SamhsaSensitive-initial-history.md)
* [SamhsaSensitive-split-history](Provenance-SamhsaSensitive-split-history.md)
* [SamhsaSensitive-update-history](Provenance-SamhsaSensitive-update-history.md)

### Examples

* [AB352ValueSetBundle (Bundle)](Bundle-AB352ValueSetBundle.md)
* [LeapSlsBundledSensitiveKindCodes (Bundle)](Bundle-LeapSlsBundledSensitiveKindCodes.md)
* [SamhsaSensitiveBundle (Bundle)](Bundle-SamhsaSensitiveBundle.md)
* [SyntheaSensitiveValueSetsBundle (Bundle)](Bundle-SyntheaSensitiveValueSetsBundle.md)
* [Consent-AB352-Example-AllowAll (Consent)](Consent-Consent-AB352-Example-AllowAll.md)
* [Consent-AB352-Example (Consent)](Consent-Consent-AB352-Example.md)
* [Consent-AB352-Example2 (Consent)](Consent-Consent-AB352-Example2.md)
* [Consent-AB352-Example4 (Consent)](Consent-Consent-AB352-Example4.md)
* [ca-location (Location)](Location-ca-location.md)
