# Synthea Codes for spina_bifida - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for spina_bifida**

## ValueSet: Synthea Codes for spina_bifida 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSpinaBifidaVS | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:SyntheaSpinaBifidaVS |
| **Usage:**Clinical Focus: genetic disease information sensitivity | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: spina_bifida. 
v3-ActCode#GDIS 

 **References** 

* Included into [SyntheaCognitiveVS](ValueSet-SyntheaCognitiveVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaSpinaBifidaVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSpinaBifidaVS",
  "version" : "0.1.0",
  "name" : "SyntheaSpinaBifidaVS",
  "title" : "Synthea Codes for spina_bifida",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: spina_bifida.\n\nv3-ActCode#GDIS",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "GDIS"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "414667000"
          },
          {
            "code" : "171131006"
          },
          {
            "code" : "76916001"
          },
          {
            "code" : "32485007"
          },
          {
            "code" : "42839003"
          },
          {
            "code" : "308335008"
          },
          {
            "code" : "230745008"
          },
          {
            "code" : "47020004"
          },
          {
            "code" : "363215001"
          },
          {
            "code" : "298382003"
          },
          {
            "code" : "302297009"
          },
          {
            "code" : "120991000119102"
          },
          {
            "code" : "84728005"
          },
          {
            "code" : "373587001"
          },
          {
            "code" : "441763001"
          },
          {
            "code" : "17881005"
          },
          {
            "code" : "414564002"
          },
          {
            "code" : "303653007"
          },
          {
            "code" : "241645008"
          },
          {
            "code" : "9002005"
          },
          {
            "code" : "1003755004"
          },
          {
            "code" : "252895004"
          },
          {
            "code" : "709640007"
          },
          {
            "code" : "68566005"
          },
          {
            "code" : "1163220007"
          }
        ]
      }
    ]
  }
}

```
