# Synthea Codes for self_harm - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for self_harm**

## ValueSet: Synthea Codes for self_harm 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSelfHarmVS | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:SyntheaSelfHarmVS |
| **Usage:**Clinical Focus: sexual assault, abuse, or domestic violence information sensitivity | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: self_harm. 
v3-ActCode#SDV 

 **References** 

* Included into [SyntheaMentalBehavioralHealthVS](ValueSet-SyntheaMentalBehavioralHealthVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaSelfHarmVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSelfHarmVS",
  "version" : "0.1.0",
  "name" : "SyntheaSelfHarmVS",
  "title" : "Synthea Codes for self_harm",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: self_harm.\n\nv3-ActCode#SDV",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "SDV"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "86849004"
          },
          {
            "code" : "287185009"
          },
          {
            "code" : "287182007"
          },
          {
            "code" : "50849002"
          },
          {
            "code" : "90407005"
          },
          {
            "code" : "74857009"
          },
          {
            "code" : "185347001"
          },
          {
            "code" : "183401008"
          },
          {
            "code" : "88848003"
          },
          {
            "code" : "287193009"
          },
          {
            "code" : "287191006"
          },
          {
            "code" : "44301001"
          },
          {
            "code" : "29240004"
          }
        ]
      }
    ]
  }
}

```
