# Synthea Codes for opioid_addiction - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for opioid_addiction**

## ValueSet: Synthea Codes for opioid_addiction 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaOpioidAddictionVS | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:SyntheaOpioidAddictionVS |
| **Usage:**Clinical Focus: opioid use disorder information sensitivity | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: opioid_addiction. 
v3-ActCode#OPIOIDUD 

 **References** 

* Included into [SyntheaSubstanceAbuseVS](ValueSet-SyntheaSubstanceAbuseVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaOpioidAddictionVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaOpioidAddictionVS",
  "version" : "0.1.0",
  "name" : "SyntheaOpioidAddictionVS",
  "title" : "Synthea Codes for opioid_addiction",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: opioid_addiction.\n\nv3-ActCode#OPIOIDUD",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "OPIOIDUD"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "196416002"
          },
          {
            "code" : "50849002"
          },
          {
            "code" : "65546002"
          },
          {
            "code" : "82423001"
          },
          {
            "code" : "183452005"
          },
          {
            "code" : "124171000119105"
          },
          {
            "code" : "56876005"
          },
          {
            "code" : "185347001"
          },
          {
            "code" : "1149222004"
          },
          {
            "code" : "734163000"
          },
          {
            "code" : "52052004"
          },
          {
            "code" : "6525002"
          }
        ]
      },
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "72514-3"
          }
        ]
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "concept" : [
          {
            "code" : "856987"
          },
          {
            "code" : "1860154"
          },
          {
            "code" : "1049221"
          }
        ]
      }
    ]
  }
}

```
