# Synthea Mental and Behavioral Health Codes - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Mental and Behavioral Health Codes**

## ValueSet: Synthea Mental and Behavioral Health Codes 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaMentalBehavioralHealthVS | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:SyntheaMentalBehavioralHealthVS |
| **Usage:**Clinical Focus: behavioral health information sensitivity | |

 
A comprehensive ValueSet encompassing codes from all Synthea modules related to mental health conditions, including ADD, PTSD, and self-harm events. 
v3-ActCode#BH 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaMentalBehavioralHealthVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaMentalBehavioralHealthVS",
  "version" : "0.1.0",
  "name" : "SyntheaMentalBehavioralHealthVS",
  "title" : "Synthea Mental and Behavioral Health Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A comprehensive ValueSet encompassing codes from all Synthea modules related to mental health conditions, including ADD, PTSD, and self-harm events.\n\nv3-ActCode#BH",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "BH"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "valueSet" : [
          "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaAttentionDeficitDisorderVS"
        ]
      },
      {
        "valueSet" : [
          "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSelfHarmVS"
        ]
      }
    ]
  }
}

```
