# Synthea Codes for cerebral_palsy - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for cerebral_palsy**

## ValueSet: Synthea Codes for cerebral_palsy 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCerebralPalsyVS | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:SyntheaCerebralPalsyVS |
| **Usage:**Clinical Focus: disability insurance policy | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: cerebral_palsy. 

 **References** 

* Included into [SyntheaCognitiveVS](ValueSet-SyntheaCognitiveVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaCerebralPalsyVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCerebralPalsyVS",
  "version" : "0.1.0",
  "name" : "SyntheaCerebralPalsyVS",
  "title" : "Synthea Codes for cerebral_palsy",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: cerebral_palsy.",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "DIS"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "1259900009"
          },
          {
            "code" : "128188000"
          },
          {
            "code" : "108219001"
          },
          {
            "code" : "311834001"
          },
          {
            "code" : "288959006"
          },
          {
            "code" : "182836005"
          },
          {
            "code" : "717778001"
          },
          {
            "code" : "229069003"
          },
          {
            "code" : "166001"
          },
          {
            "code" : "311707005"
          },
          {
            "code" : "312421008"
          },
          {
            "code" : "62718007"
          },
          {
            "code" : "173521004"
          },
          {
            "code" : "47227006"
          },
          {
            "code" : "302351005"
          },
          {
            "code" : "53827007"
          },
          {
            "code" : "390906007"
          },
          {
            "code" : "267064002"
          },
          {
            "code" : "14760008"
          },
          {
            "code" : "389082000"
          },
          {
            "code" : "386490009"
          },
          {
            "code" : "40274000"
          },
          {
            "code" : "183646003"
          },
          {
            "code" : "15802004"
          },
          {
            "code" : "22253000"
          },
          {
            "code" : "398152000"
          },
          {
            "code" : "221360009"
          },
          {
            "code" : "64859006"
          },
          {
            "code" : "84757009"
          },
          {
            "code" : "110359009"
          },
          {
            "code" : "235595009"
          },
          {
            "code" : "371883000"
          },
          {
            "code" : "404909007"
          },
          {
            "code" : "241149003"
          },
          {
            "code" : "182777000"
          },
          {
            "code" : "233604007"
          },
          {
            "code" : "157265008"
          }
        ]
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "concept" : [
          {
            "code" : "1437975"
          },
          {
            "code" : "351875"
          },
          {
            "code" : "885219"
          },
          {
            "code" : "905269"
          },
          {
            "code" : "1789958"
          },
          {
            "code" : "860182"
          },
          {
            "code" : "1190766"
          }
        ]
      }
    ]
  }
}

```
