# clinical codes that indicate SDV - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **clinical codes that indicate SDV**

## ValueSet: clinical codes that indicate SDV 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveSDV | *Version*:0.1.0 |
| Active as of 2016-09-09 | *Computable Name*:SamhsaSensitiveSDV |
| **Usage:**Clinical Focus: sexual assault, abuse, or domestic violence information sensitivity | |

 
SDV - Sexual assault, abuse or domestic violence 
??should this also include SEX (sexuality and reproductive health information sensitivity), PREGNANT (pregnancy), STD (sexually transmitted disease)? The SAMHSA valuesets seem to be labeled as if they are only about sexuality and reproductive health, but do include sexual abuse and sexually transmitted disease. 
* **SAMHSA C2S Sexuality and reproductive health information sensitivity** 
* ValueSet 2.16.840.1.113762.1.4.1142.49 // ICD9CM
* ValueSet 2.16.840.1.113762.1.4.1142.50 // RXNORM
 
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SamhsaSensitiveSDV",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveSDV",
  "version" : "0.1.0",
  "name" : "SamhsaSensitiveSDV",
  "title" : "clinical codes that indicate SDV",
  "status" : "active",
  "experimental" : false,
  "date" : "2016-09-09",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "SDV - Sexual assault, abuse or domestic violence\n\n??should this also include SEX (sexuality and reproductive health information sensitivity), PREGNANT (pregnancy), STD (sexually transmitted disease)? The SAMHSA valuesets seem to be labeled as if they are only about sexuality and reproductive health, but do include sexual abuse and sexually transmitted disease.\n\n* **SAMHSA C2S Sexuality and reproductive health information sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.49 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.50 // RXNORM",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "SDV"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.49"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.50"
        ]
      }
    ]
  }
}

```
