# Gender-Affirming Care Codes (Health Net California) - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Gender-Affirming Care Codes (Health Net California)**

## ValueSet: Gender-Affirming Care Codes (Health Net California) 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352GenderAffirmingCareHealthNet | *Version*:0.1.0 |
| Active as of 2024-01-01 | *Computable Name*:AB352GenderAffirmingCareHealthNet |
| **Usage:**Clinical Focus: Gender-affirming care | |

 
CPT and ICD-10-CM codes referenced in Health Net California's clinical policy 'HNCA.CP.MP.496 - Gender Affirming Procedures'. Intended for segmentation of gender-affirming care under AB352. 
**Health Net Bulletin 24-351** 
Health Net's [bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/) explicitly tells providers that services defined in policies like HNCA.CP.MP.496 must be: 
* **Blocked from automatic sharing** with the California Data Exchange Framework (DxF).
* **Omitted from responses** to out-of-state subpoenas or investigations.
* **Flagged within the EHR** to prevent unauthorized access by users outside of California.
 
**Where to Find and Download HNCA.CP.MP.496.pdf** Health Net maintains this policy in several locations within their provider libraries: 
* **Direct PDF Link:** [HNCA.CP.MP.496 - Gender Affirming Procedures](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/HNCA.CP.MP.496.pdf)
* **The Provider Library Archive:** You can find this by navigating to Health Net Provider Library > Resources > Clinical Policies and searching for `Gender Affirming Procedures` or the code `496.`
 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "AB352GenderAffirmingCareHealthNet",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/AB352GenderAffirmingCareHealthNet",
  "version" : "0.1.0",
  "name" : "AB352GenderAffirmingCareHealthNet",
  "title" : "Gender-Affirming Care Codes (Health Net California)",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-01T00:00:00Z",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "CPT and ICD-10-CM codes referenced in Health Net California's clinical policy\n'HNCA.CP.MP.496 - Gender Affirming Procedures'. Intended for segmentation of\ngender-affirming care under AB352.\n\n**Health Net Bulletin 24-351**\n\nHealth Net's [bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/) explicitly tells providers that services defined in policies like HNCA.CP.MP.496 must be:\n\n- **Blocked from automatic sharing** with the California Data Exchange Framework (DxF).\n- **Omitted from responses** to out-of-state subpoenas or investigations.\n- **Flagged within the EHR** to prevent unauthorized access by users outside of California.\n\n**Where to Find and Download HNCA.CP.MP.496.pdf** Health Net maintains this policy in several locations within their provider libraries:\n\n- **Direct PDF Link:** [HNCA.CP.MP.496 - Gender Affirming Procedures](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/HNCA.CP.MP.496.pdf)\n- **The Provider Library Archive:** You can find this by navigating to Health Net Provider Library > Resources > Clinical Policies and searching for `Gender Affirming Procedures` or the code `496.`",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
            "code" : "GENDER_AFFIRMING_CARE"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://www.ama-assn.org/go/cpt",
        "concept" : [
          {
            "code" : "11960"
          },
          {
            "code" : "11950"
          },
          {
            "code" : "11951"
          },
          {
            "code" : "11952"
          },
          {
            "code" : "11954"
          },
          {
            "code" : "11970"
          },
          {
            "code" : "14000"
          },
          {
            "code" : "14001"
          },
          {
            "code" : "14040"
          },
          {
            "code" : "14041"
          },
          {
            "code" : "15100"
          },
          {
            "code" : "15101"
          },
          {
            "code" : "15120"
          },
          {
            "code" : "15121"
          },
          {
            "code" : "15200"
          },
          {
            "code" : "15570"
          },
          {
            "code" : "15574"
          },
          {
            "code" : "15600"
          },
          {
            "code" : "15620"
          },
          {
            "code" : "15757"
          },
          {
            "code" : "15758"
          },
          {
            "code" : "15775"
          },
          {
            "code" : "15776"
          },
          {
            "code" : "15780"
          },
          {
            "code" : "15781"
          },
          {
            "code" : "15782"
          },
          {
            "code" : "15783"
          },
          {
            "code" : "15786"
          },
          {
            "code" : "15787"
          },
          {
            "code" : "15788"
          },
          {
            "code" : "15789"
          },
          {
            "code" : "15792"
          },
          {
            "code" : "15793"
          },
          {
            "code" : "15820"
          },
          {
            "code" : "15821"
          },
          {
            "code" : "15822"
          },
          {
            "code" : "15823"
          },
          {
            "code" : "15824"
          },
          {
            "code" : "15825"
          },
          {
            "code" : "15826"
          },
          {
            "code" : "15828"
          },
          {
            "code" : "15829"
          },
          {
            "code" : "15830"
          },
          {
            "code" : "15832"
          },
          {
            "code" : "15833"
          },
          {
            "code" : "15834"
          },
          {
            "code" : "15835"
          },
          {
            "code" : "15836"
          },
          {
            "code" : "15837"
          },
          {
            "code" : "15838"
          },
          {
            "code" : "15839"
          },
          {
            "code" : "15876"
          },
          {
            "code" : "15877"
          },
          {
            "code" : "15878"
          },
          {
            "code" : "15879"
          },
          {
            "code" : "17380"
          },
          {
            "code" : "19300"
          },
          {
            "code" : "19301"
          },
          {
            "code" : "19303"
          },
          {
            "code" : "19316"
          },
          {
            "code" : "19318"
          },
          {
            "code" : "19325"
          },
          {
            "code" : "19350"
          },
          {
            "code" : "21120"
          },
          {
            "code" : "21121"
          },
          {
            "code" : "21122"
          },
          {
            "code" : "21123"
          },
          {
            "code" : "21125"
          },
          {
            "code" : "21127"
          },
          {
            "code" : "21208"
          },
          {
            "code" : "21209"
          },
          {
            "code" : "21210"
          },
          {
            "code" : "21270"
          },
          {
            "code" : "30400"
          },
          {
            "code" : "30410"
          },
          {
            "code" : "30420"
          },
          {
            "code" : "30430"
          },
          {
            "code" : "30435"
          },
          {
            "code" : "30450"
          },
          {
            "code" : "31580"
          },
          {
            "code" : "31587"
          },
          {
            "code" : "31599"
          },
          {
            "code" : "31899"
          },
          {
            "code" : "44145"
          },
          {
            "code" : "53400"
          },
          {
            "code" : "53405"
          },
          {
            "code" : "53410"
          },
          {
            "code" : "53415"
          },
          {
            "code" : "53420"
          },
          {
            "code" : "53425"
          },
          {
            "code" : "53430"
          },
          {
            "code" : "53460"
          },
          {
            "code" : "54125"
          },
          {
            "code" : "54340"
          },
          {
            "code" : "54400"
          },
          {
            "code" : "54401"
          },
          {
            "code" : "54405"
          },
          {
            "code" : "54406"
          },
          {
            "code" : "54408"
          },
          {
            "code" : "54410"
          },
          {
            "code" : "54411"
          },
          {
            "code" : "54415"
          },
          {
            "code" : "54416"
          },
          {
            "code" : "54417"
          },
          {
            "code" : "54520"
          },
          {
            "code" : "54660"
          },
          {
            "code" : "54690"
          },
          {
            "code" : "55175"
          },
          {
            "code" : "55180"
          },
          {
            "code" : "55970"
          },
          {
            "code" : "55980"
          },
          {
            "code" : "56625"
          },
          {
            "code" : "56800"
          },
          {
            "code" : "56805"
          },
          {
            "code" : "56810"
          },
          {
            "code" : "57106"
          },
          {
            "code" : "57107"
          },
          {
            "code" : "57110"
          },
          {
            "code" : "57111"
          },
          {
            "code" : "57291"
          },
          {
            "code" : "57292"
          },
          {
            "code" : "57295"
          },
          {
            "code" : "57296"
          },
          {
            "code" : "57335"
          },
          {
            "code" : "57426"
          },
          {
            "code" : "58150"
          },
          {
            "code" : "58180"
          },
          {
            "code" : "58260"
          },
          {
            "code" : "58262"
          },
          {
            "code" : "58263"
          },
          {
            "code" : "58267"
          },
          {
            "code" : "58270"
          },
          {
            "code" : "58275"
          },
          {
            "code" : "58280"
          },
          {
            "code" : "58285"
          }
        ]
      }
    ]
  }
}

```
