# Health Information Sensitivity Categories - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Health Information Sensitivity Categories**

## CodeSystem: Health Information Sensitivity Categories 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:AB352HealthSensitivityCs |

 
Code system defining sensitivity categories for health information segmentation under California AB352. 
Note did not use HL7 v2-ActCodes as two of the three categories are not represented there, and the GENDER code may be more broad than GENDER_AFFIRMING_CARE as intended here. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AB352SegmentationTags](ValueSet-AB352SegmentationTags.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "AB352HealthSensitivityCs",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/CodeSystem/AB352HealthSensitivityCs",
  "version" : "0.1.0",
  "name" : "AB352HealthSensitivityCs",
  "title" : "Health Information Sensitivity Categories",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "Code system defining sensitivity categories for health information segmentation under California AB352.\n\nNote did not use HL7 v2-ActCodes as two of the three categories are not represented there, and the GENDER code may be more broad than GENDER_AFFIRMING_CARE as intended here.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "concept" : [
    {
      "code" : "ABORTION",
      "display" : "Abortion-related services",
      "definition" : "Health information related to abortion services, including procedures, counseling, and follow-up care."
    },
    {
      "code" : "GENDER_AFFIRMING_CARE",
      "display" : "Gender-affirming care",
      "definition" : "Health information related to gender-affirming care, including hormone therapy, surgeries, and counseling."
    },
    {
      "code" : "CONTRACEPTION",
      "display" : "Contraception",
      "definition" : "Health information related to contraception methods, counseling, and management."
    }
  ]
}

```
