# Synthea Sensitive Value Sets Bundle - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Sensitive Value Sets Bundle**

## Example Bundle: Synthea Sensitive Value Sets Bundle



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "SyntheaSensitiveValueSetsBundle",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaAttentionDeficitDisorderVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaAttentionDeficitDisorderVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaAttentionDeficitDisorderVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaAttentionDeficitDisorderVS</b></p><a name=\"SyntheaAttentionDeficitDisorderVS\"> </a><a name=\"hcSyntheaAttentionDeficitDisorderVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaAttentionDeficitDisorderVS.html\">Synthea Codes for attention_deficit_disorder</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaAttentionDeficitDisorderVS</p><p><b>title</b>: Synthea Codes for attention_deficit_disorder</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: attention_deficit_disorder.</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode PSY}\">psychiatry disorder information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 192127007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 185347001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 386522008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 228557008</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://www.nlm.nih.gov/research/umls/rxnorm/index.html\">http://www.nlm.nih.gov/research/umls/rxnorm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 1091392</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 608139</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaAttentionDeficitDisorderVS",
        "version" : "0.1.0",
        "name" : "SyntheaAttentionDeficitDisorderVS",
        "title" : "Synthea Codes for attention_deficit_disorder",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: attention_deficit_disorder.",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "PSY"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "192127007"
                },
                {
                  "code" : "185347001"
                },
                {
                  "code" : "386522008"
                },
                {
                  "code" : "228557008"
                }
              ]
            },
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "concept" : [
                {
                  "code" : "1091392"
                },
                {
                  "code" : "608139"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCerebralPalsyVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaCerebralPalsyVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaCerebralPalsyVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaCerebralPalsyVS</b></p><a name=\"SyntheaCerebralPalsyVS\"> </a><a name=\"hcSyntheaCerebralPalsyVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaCerebralPalsyVS.html\">Synthea Codes for cerebral_palsy</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaCerebralPalsyVS</p><p><b>title</b>: Synthea Codes for cerebral_palsy</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: cerebral_palsy.</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode DIS}\">disability insurance policy</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 1259900009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 128188000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 108219001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 311834001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 288959006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 182836005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 717778001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 229069003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 166001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 311707005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 312421008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 62718007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 173521004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 47227006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 302351005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 53827007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 390906007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 267064002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 14760008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 389082000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 386490009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 40274000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 183646003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 15802004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 22253000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 398152000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 221360009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 64859006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 84757009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 110359009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 235595009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 371883000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 404909007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 241149003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 182777000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 233604007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 157265008</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://www.nlm.nih.gov/research/umls/rxnorm/index.html\">http://www.nlm.nih.gov/research/umls/rxnorm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 1437975</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 351875</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 885219</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 905269</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1789958</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 860182</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1190766</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCerebralPalsyVS",
        "version" : "0.1.0",
        "name" : "SyntheaCerebralPalsyVS",
        "title" : "Synthea Codes for cerebral_palsy",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: cerebral_palsy.",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "DIS"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "1259900009"
                },
                {
                  "code" : "128188000"
                },
                {
                  "code" : "108219001"
                },
                {
                  "code" : "311834001"
                },
                {
                  "code" : "288959006"
                },
                {
                  "code" : "182836005"
                },
                {
                  "code" : "717778001"
                },
                {
                  "code" : "229069003"
                },
                {
                  "code" : "166001"
                },
                {
                  "code" : "311707005"
                },
                {
                  "code" : "312421008"
                },
                {
                  "code" : "62718007"
                },
                {
                  "code" : "173521004"
                },
                {
                  "code" : "47227006"
                },
                {
                  "code" : "302351005"
                },
                {
                  "code" : "53827007"
                },
                {
                  "code" : "390906007"
                },
                {
                  "code" : "267064002"
                },
                {
                  "code" : "14760008"
                },
                {
                  "code" : "389082000"
                },
                {
                  "code" : "386490009"
                },
                {
                  "code" : "40274000"
                },
                {
                  "code" : "183646003"
                },
                {
                  "code" : "15802004"
                },
                {
                  "code" : "22253000"
                },
                {
                  "code" : "398152000"
                },
                {
                  "code" : "221360009"
                },
                {
                  "code" : "64859006"
                },
                {
                  "code" : "84757009"
                },
                {
                  "code" : "110359009"
                },
                {
                  "code" : "235595009"
                },
                {
                  "code" : "371883000"
                },
                {
                  "code" : "404909007"
                },
                {
                  "code" : "241149003"
                },
                {
                  "code" : "182777000"
                },
                {
                  "code" : "233604007"
                },
                {
                  "code" : "157265008"
                }
              ]
            },
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "concept" : [
                {
                  "code" : "1437975"
                },
                {
                  "code" : "351875"
                },
                {
                  "code" : "885219"
                },
                {
                  "code" : "905269"
                },
                {
                  "code" : "1789958"
                },
                {
                  "code" : "860182"
                },
                {
                  "code" : "1190766"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCysticFibrosisVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaCysticFibrosisVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaCysticFibrosisVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaCysticFibrosisVS</b></p><a name=\"SyntheaCysticFibrosisVS\"> </a><a name=\"hcSyntheaCysticFibrosisVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaCysticFibrosisVS.html\">Synthea Codes for cystic_fibrosis</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaCysticFibrosisVS</p><p><b>title</b>: Synthea Codes for cystic_fibrosis</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: cystic_fibrosis.</p>\n<p>v3-ActCode#GDIS</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode GDIS}\">genetic disease information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 190905008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 67799006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 86964003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 444260001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 206523001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 61919008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 707418001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 707577004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 60151004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 734163000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 185349003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 399208008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 104173009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 427089005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 113076002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 703040004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 232657004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 82078001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 23426006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11218009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 406602003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 448813005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 50849002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 14152002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 281790008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 448417001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 48387007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 65710008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 16602611000119108</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://www.nlm.nih.gov/research/umls/rxnorm/index.html\">http://www.nlm.nih.gov/research/umls/rxnorm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 198767</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1243052</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 205532</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1665227</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 313572</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaCysticFibrosisVS",
        "version" : "0.1.0",
        "name" : "SyntheaCysticFibrosisVS",
        "title" : "Synthea Codes for cystic_fibrosis",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: cystic_fibrosis.\n\nv3-ActCode#GDIS",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "GDIS"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "190905008"
                },
                {
                  "code" : "67799006"
                },
                {
                  "code" : "86964003"
                },
                {
                  "code" : "444260001"
                },
                {
                  "code" : "206523001"
                },
                {
                  "code" : "61919008"
                },
                {
                  "code" : "707418001"
                },
                {
                  "code" : "707577004"
                },
                {
                  "code" : "60151004"
                },
                {
                  "code" : "734163000"
                },
                {
                  "code" : "185349003"
                },
                {
                  "code" : "399208008"
                },
                {
                  "code" : "104173009"
                },
                {
                  "code" : "427089005"
                },
                {
                  "code" : "113076002"
                },
                {
                  "code" : "703040004"
                },
                {
                  "code" : "232657004"
                },
                {
                  "code" : "82078001"
                },
                {
                  "code" : "23426006"
                },
                {
                  "code" : "11218009"
                },
                {
                  "code" : "406602003"
                },
                {
                  "code" : "448813005"
                },
                {
                  "code" : "50849002"
                },
                {
                  "code" : "14152002"
                },
                {
                  "code" : "281790008"
                },
                {
                  "code" : "448417001"
                },
                {
                  "code" : "48387007"
                },
                {
                  "code" : "65710008"
                },
                {
                  "code" : "16602611000119108"
                }
              ]
            },
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "concept" : [
                {
                  "code" : "198767"
                },
                {
                  "code" : "1243052"
                },
                {
                  "code" : "205532"
                },
                {
                  "code" : "1665227"
                },
                {
                  "code" : "313572"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaDementiaVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaDementiaVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaDementiaVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaDementiaVS</b></p><a name=\"SyntheaDementiaVS\"> </a><a name=\"hcSyntheaDementiaVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaDementiaVS.html\">Synthea Codes for dementia</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaDementiaVS</p><p><b>title</b>: Synthea Codes for dementia</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: dementia.</p>\n<p>v3-ActCode#COGN</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode COGN}\">cognitive disability information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 26929004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 230265002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 386257007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 281036007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 233604007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 4525004</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://loinc.org/\">http://loinc.org</a></p><h3>Concepts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>72106-8</td></tr></table></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://www.nlm.nih.gov/research/umls/rxnorm/index.html\">http://www.nlm.nih.gov/research/umls/rxnorm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 310436</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 997223</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 313185</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1599803</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 996740</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1100184</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaDementiaVS",
        "version" : "0.1.0",
        "name" : "SyntheaDementiaVS",
        "title" : "Synthea Codes for dementia",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: dementia.\n\nv3-ActCode#COGN",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "COGN"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "26929004"
                },
                {
                  "code" : "230265002"
                },
                {
                  "code" : "386257007"
                },
                {
                  "code" : "281036007"
                },
                {
                  "code" : "233604007"
                },
                {
                  "code" : "4525004"
                }
              ]
            },
            {
              "system" : "http://loinc.org",
              "concept" : [
                {
                  "code" : "72106-8"
                }
              ]
            },
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "concept" : [
                {
                  "code" : "310436"
                },
                {
                  "code" : "997223"
                },
                {
                  "code" : "313185"
                },
                {
                  "code" : "1599803"
                },
                {
                  "code" : "996740"
                },
                {
                  "code" : "1100184"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaOpioidAddictionVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaOpioidAddictionVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaOpioidAddictionVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaOpioidAddictionVS</b></p><a name=\"SyntheaOpioidAddictionVS\"> </a><a name=\"hcSyntheaOpioidAddictionVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaOpioidAddictionVS.html\">Synthea Codes for opioid_addiction</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaOpioidAddictionVS</p><p><b>title</b>: Synthea Codes for opioid_addiction</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: opioid_addiction.</p>\n<p>v3-ActCode#OPIOIDUD</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode OPIOIDUD}\">opioid use disorder information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 196416002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 50849002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 65546002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 82423001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 183452005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 124171000119105</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 56876005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 185347001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1149222004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 734163000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 52052004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 6525002</p></blockquote></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://loinc.org/\">http://loinc.org</a></p><h3>Concepts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td></tr><tr><td style=\"display: none\">*</td><td>72514-3</td></tr></table></blockquote><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://www.nlm.nih.gov/research/umls/rxnorm/index.html\">http://www.nlm.nih.gov/research/umls/rxnorm</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 856987</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1860154</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1049221</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaOpioidAddictionVS",
        "version" : "0.1.0",
        "name" : "SyntheaOpioidAddictionVS",
        "title" : "Synthea Codes for opioid_addiction",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: opioid_addiction.\n\nv3-ActCode#OPIOIDUD",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "OPIOIDUD"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "196416002"
                },
                {
                  "code" : "50849002"
                },
                {
                  "code" : "65546002"
                },
                {
                  "code" : "82423001"
                },
                {
                  "code" : "183452005"
                },
                {
                  "code" : "124171000119105"
                },
                {
                  "code" : "56876005"
                },
                {
                  "code" : "185347001"
                },
                {
                  "code" : "1149222004"
                },
                {
                  "code" : "734163000"
                },
                {
                  "code" : "52052004"
                },
                {
                  "code" : "6525002"
                }
              ]
            },
            {
              "system" : "http://loinc.org",
              "concept" : [
                {
                  "code" : "72514-3"
                }
              ]
            },
            {
              "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
              "concept" : [
                {
                  "code" : "856987"
                },
                {
                  "code" : "1860154"
                },
                {
                  "code" : "1049221"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaPregnancyVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaPregnancyVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaPregnancyVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaPregnancyVS</b></p><a name=\"SyntheaPregnancyVS\"> </a><a name=\"hcSyntheaPregnancyVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaPregnancyVS.html\">Synthea Codes for pregnancy</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaPregnancyVS</p><p><b>title</b>: Synthea Codes for pregnancy</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: pregnancy.</p>\n<p>v3-ActCode#PREGNANT</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode PREGNANT}\">pregnancy information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 72892002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 424441002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 252160004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 169230002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 134435003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 274804006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 225158009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 44608003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 104091002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 47758006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 31676001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 310861008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 165829005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 269828009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 117010004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 90226004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 395123002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 104375008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 314098000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 104326007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 28163009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 60218003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 5880005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 47200007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 424619006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 443529005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 271442007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 275833003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 169673001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 51116004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 399014008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 268556000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 398254007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 198992004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 118001005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 183460006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 31208007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 18946005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 237001001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 85548006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 236974004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 177157003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 386216000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 367494004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 11466000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 19169002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 85116003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 156073000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 35999006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 305408004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 236931002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 445912000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 267253006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 37849005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 609496007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 171207006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 270427003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 10383002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 714812005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 386394001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 169762003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 133899007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 79586000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 161744009</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaPregnancyVS",
        "version" : "0.1.0",
        "name" : "SyntheaPregnancyVS",
        "title" : "Synthea Codes for pregnancy",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: pregnancy.\n\nv3-ActCode#PREGNANT",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "PREGNANT"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "72892002"
                },
                {
                  "code" : "424441002"
                },
                {
                  "code" : "252160004"
                },
                {
                  "code" : "169230002"
                },
                {
                  "code" : "134435003"
                },
                {
                  "code" : "274804006"
                },
                {
                  "code" : "225158009"
                },
                {
                  "code" : "44608003"
                },
                {
                  "code" : "104091002"
                },
                {
                  "code" : "47758006"
                },
                {
                  "code" : "31676001"
                },
                {
                  "code" : "310861008"
                },
                {
                  "code" : "165829005"
                },
                {
                  "code" : "269828009"
                },
                {
                  "code" : "117010004"
                },
                {
                  "code" : "90226004"
                },
                {
                  "code" : "395123002"
                },
                {
                  "code" : "104375008"
                },
                {
                  "code" : "314098000"
                },
                {
                  "code" : "104326007"
                },
                {
                  "code" : "28163009"
                },
                {
                  "code" : "60218003"
                },
                {
                  "code" : "5880005"
                },
                {
                  "code" : "47200007"
                },
                {
                  "code" : "424619006"
                },
                {
                  "code" : "443529005"
                },
                {
                  "code" : "271442007"
                },
                {
                  "code" : "275833003"
                },
                {
                  "code" : "169673001"
                },
                {
                  "code" : "51116004"
                },
                {
                  "code" : "399014008"
                },
                {
                  "code" : "268556000"
                },
                {
                  "code" : "398254007"
                },
                {
                  "code" : "198992004"
                },
                {
                  "code" : "118001005"
                },
                {
                  "code" : "183460006"
                },
                {
                  "code" : "31208007"
                },
                {
                  "code" : "18946005"
                },
                {
                  "code" : "237001001"
                },
                {
                  "code" : "85548006"
                },
                {
                  "code" : "236974004"
                },
                {
                  "code" : "177157003"
                },
                {
                  "code" : "386216000"
                },
                {
                  "code" : "367494004"
                },
                {
                  "code" : "11466000"
                },
                {
                  "code" : "19169002"
                },
                {
                  "code" : "85116003"
                },
                {
                  "code" : "156073000"
                },
                {
                  "code" : "35999006"
                },
                {
                  "code" : "305408004"
                },
                {
                  "code" : "236931002"
                },
                {
                  "code" : "445912000"
                },
                {
                  "code" : "267253006"
                },
                {
                  "code" : "37849005"
                },
                {
                  "code" : "609496007"
                },
                {
                  "code" : "171207006"
                },
                {
                  "code" : "270427003"
                },
                {
                  "code" : "10383002"
                },
                {
                  "code" : "714812005"
                },
                {
                  "code" : "386394001"
                },
                {
                  "code" : "169762003"
                },
                {
                  "code" : "133899007"
                },
                {
                  "code" : "79586000"
                },
                {
                  "code" : "161744009"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSelfHarmVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaSelfHarmVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaSelfHarmVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaSelfHarmVS</b></p><a name=\"SyntheaSelfHarmVS\"> </a><a name=\"hcSyntheaSelfHarmVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaSelfHarmVS.html\">Synthea Codes for self_harm</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaSelfHarmVS</p><p><b>title</b>: Synthea Codes for self_harm</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: self_harm.</p>\n<p>v3-ActCode#SDV</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode SDV}\">sexual assault, abuse, or domestic violence information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 86849004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 287185009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 287182007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 50849002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 90407005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 74857009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 185347001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 183401008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 88848003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 287193009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 287191006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 44301001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 29240004</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSelfHarmVS",
        "version" : "0.1.0",
        "name" : "SyntheaSelfHarmVS",
        "title" : "Synthea Codes for self_harm",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: self_harm.\n\nv3-ActCode#SDV",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "SDV"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "86849004"
                },
                {
                  "code" : "287185009"
                },
                {
                  "code" : "287182007"
                },
                {
                  "code" : "50849002"
                },
                {
                  "code" : "90407005"
                },
                {
                  "code" : "74857009"
                },
                {
                  "code" : "185347001"
                },
                {
                  "code" : "183401008"
                },
                {
                  "code" : "88848003"
                },
                {
                  "code" : "287193009"
                },
                {
                  "code" : "287191006"
                },
                {
                  "code" : "44301001"
                },
                {
                  "code" : "29240004"
                }
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSpinaBifidaVS",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SyntheaSpinaBifidaVS",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SyntheaSpinaBifidaVS\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SyntheaSpinaBifidaVS</b></p><a name=\"SyntheaSpinaBifidaVS\"> </a><a name=\"hcSyntheaSpinaBifidaVS\"> </a><p><b>url</b>: <a href=\"ValueSet-SyntheaSpinaBifidaVS.html\">Synthea Codes for spina_bifida</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SyntheaSpinaBifidaVS</p><p><b>title</b>: Synthea Codes for spina_bifida</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>description</b>: </p><div><p>A ValueSet containing all clinical codes found in the sensitive Synthea module: spina_bifida.</p>\n<p>v3-ActCode#GDIS</p>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode GDIS}\">genetic disease information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>system</b>: <a href=\"https://browser.ihtsdotools.org/\">http://snomed.info/sct</a></p><blockquote><p><b>concept</b></p><p><b>code</b>: 414667000</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 171131006</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 76916001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 32485007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 42839003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 308335008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 230745008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 47020004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 363215001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 298382003</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 302297009</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 120991000119102</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 84728005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 373587001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 441763001</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 17881005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 414564002</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 303653007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 241645008</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 9002005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1003755004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 252895004</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 709640007</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 68566005</p></blockquote><blockquote><p><b>concept</b></p><p><b>code</b>: 1163220007</p></blockquote></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaSpinaBifidaVS",
        "version" : "0.1.0",
        "name" : "SyntheaSpinaBifidaVS",
        "title" : "Synthea Codes for spina_bifida",
        "status" : "active",
        "experimental" : false,
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: spina_bifida.\n\nv3-ActCode#GDIS",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "GDIS"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "system" : "http://snomed.info/sct",
              "concept" : [
                {
                  "code" : "414667000"
                },
                {
                  "code" : "171131006"
                },
                {
                  "code" : "76916001"
                },
                {
                  "code" : "32485007"
                },
                {
                  "code" : "42839003"
                },
                {
                  "code" : "308335008"
                },
                {
                  "code" : "230745008"
                },
                {
                  "code" : "47020004"
                },
                {
                  "code" : "363215001"
                },
                {
                  "code" : "298382003"
                },
                {
                  "code" : "302297009"
                },
                {
                  "code" : "120991000119102"
                },
                {
                  "code" : "84728005"
                },
                {
                  "code" : "373587001"
                },
                {
                  "code" : "441763001"
                },
                {
                  "code" : "17881005"
                },
                {
                  "code" : "414564002"
                },
                {
                  "code" : "303653007"
                },
                {
                  "code" : "241645008"
                },
                {
                  "code" : "9002005"
                },
                {
                  "code" : "1003755004"
                },
                {
                  "code" : "252895004"
                },
                {
                  "code" : "709640007"
                },
                {
                  "code" : "68566005"
                },
                {
                  "code" : "1163220007"
                }
              ]
            }
          ]
        }
      }
    }
  ]
}

```
