# Bundle of all SAMHSA sensitive ValueSets - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle of all SAMHSA sensitive ValueSets**

## Example Bundle: Bundle of all SAMHSA sensitive ValueSets



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "SamhsaSensitiveBundle",
  "type" : "collection",
  "entry" : [
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitivePSY",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SamhsaSensitivePSY",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SamhsaSensitivePSY\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SamhsaSensitivePSY</b></p><a name=\"SamhsaSensitivePSY\"> </a><a name=\"hcSamhsaSensitivePSY\"> </a><p><b>url</b>: <a href=\"ValueSet-SamhsaSensitivePSY.html\">clinical codes that indicate PSY</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SamhsaSensitivePSY</p><p><b>title</b>: clinical codes that indicate PSY</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2016-09-09</p><p><b>description</b>: </p><div><p>codes that when found in data would indicate the data is likely PSY related</p>\n<p>PSY - psychiatry disorder information sensitivity</p>\n<p>??should this include MH (Mental Health), PSYTHPN (psychotherapy note), and SUD (substance use)??</p>\n<ul>\n<li><strong>SAMHSA C2S Mental Health Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.32 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.33 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.34 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.35 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.36 // SNOMED-CT</li>\n</ul>\n</li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode PSY}\">psychiatry disorder information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.32/expansion\">C2S Mental Health Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.33/expansion\">C2S Mental Health Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.34/expansion\">C2S Mental Health Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.35/expansion\">C2S Mental Health Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.36/expansion\">C2S Mental Health Disorders</a></p></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitivePSY",
        "version" : "0.1.0",
        "name" : "SamhsaSensitivePSY",
        "title" : "clinical codes that indicate PSY",
        "status" : "active",
        "experimental" : false,
        "date" : "2016-09-09",
        "description" : "codes that when found in data would indicate the data is likely PSY related\n\nPSY - psychiatry disorder information sensitivity\n\n??should this include MH (Mental Health), PSYTHPN (psychotherapy note), and SUD (substance use)??\n\n* **SAMHSA C2S Mental Health Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.32 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.33 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.34 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.35 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.36 // SNOMED-CT",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "PSY"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.32"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.33"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.34"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.35"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.36"
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETH",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SamhsaSensitiveETH",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SamhsaSensitiveETH\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SamhsaSensitiveETH</b></p><a name=\"SamhsaSensitiveETH\"> </a><a name=\"hcSamhsaSensitiveETH\"> </a><p><b>url</b>: <a href=\"ValueSet-SamhsaSensitiveETH.html\">clinical codes that indicate ETH</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SamhsaSensitiveETH</p><p><b>title</b>: clinical codes that indicate ETH</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2016-09-09</p><p><b>description</b>: </p><div><p>codes that when found in data would indicate the data is likely ETH related</p>\n<p>ETH - substance abuse information sensitivity (alcohol or drug-abuse information)</p>\n<ul>\n<li><strong>SAMHSA  C2S Alcohol Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Amphetamine Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Cannabis Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Cocaine Use Disorder</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Hallucinogens</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Inhalants</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Opioids</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Other Psychoactive Substance Use Disorder</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Substance use Information Sensitivity</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM</li>\n</ul>\n</li>\n<li><strong>SAMHSA Test C2S Alcohol Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT</li>\n</ul>\n</li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode ETH}\">substance abuse information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.1/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.2/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.3/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.4/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.5/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.10/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.11/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.6/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.7/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.8/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.9/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.12/expansion\">C2S Cannabis Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.13/expansion\">C2S Cannabis Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.14/expansion\">C2S Cannabis Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.15/expansion\">C2S Cannabis Use DIsorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.16/expansion\">C2S Cocaine Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.17/expansion\">C2S Cocaine Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.18/expansion\">C2S Cocaine Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.19/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.20/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.21/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.22/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.28/expansion\">C2S Inhalants</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.29/expansion\">C2S Inhalants</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.30/expansion\">C2S Inhalants</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.38/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.39/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.40/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.41/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.42/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.59/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.43/expansion\">C2S Other Psychoactive Substance\nUse Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.44/expansion\">C2S Other Psychoactive Substance Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.45/expansion\">C2S Other Psychoactive Substance Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.46/expansion\">C2S Sedative Hypnotic, or anxiolytic related disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.47/expansion\">C2S Sedative Hypnotic, or anxiolytic related disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.48/expansion\">C2S Sedative Hypnotic, or anxiolytic related disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.55/expansion\">C2S Substance Use Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.56/expansion\">C2S Substance Use Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.57/expansion\">C2S Substance Use Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.65/expansion\">Test C2S Alcohol Use Disorders</a></p></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETH",
        "version" : "0.1.0",
        "name" : "SamhsaSensitiveETH",
        "title" : "clinical codes that indicate ETH",
        "status" : "active",
        "experimental" : false,
        "date" : "2016-09-09",
        "description" : "codes that when found in data would indicate the data is likely ETH related\n\nETH - substance abuse information sensitivity (alcohol or drug-abuse information)\n\n* **SAMHSA  C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD\n  * ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD\n  * ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC\n* **SAMHSA C2S Amphetamine Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC\n* **SAMHSA C2S Cannabis Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT\n* **SAMHSA C2S Cocaine Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT\n* **SAMHSA C2S Hallucinogens**\n  * ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT\n* **SAMHSA C2S Inhalants**\n  * ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT\n* **SAMHSA C2S Opioids**\n  * ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT\n* **SAMHSA C2S Other Psychoactive Substance Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM\n* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM\n* **SAMHSA C2S Substance use Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM\n* **SAMHSA Test C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "ETH"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.1"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.2"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.3"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.4"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.5"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.10"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.11"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.6"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.7"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.8"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.9"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.12"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.13"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.14"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.15"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.16"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.17"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.18"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.19"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.20"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.21"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.22"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.28"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.29"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.30"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.38"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.39"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.40"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.41"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.42"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.59"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.43"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.44"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.45"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.46"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.47"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.48"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.55"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.56"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.57"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.65"
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETHUD",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SamhsaSensitiveETHUD",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SamhsaSensitiveETHUD\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SamhsaSensitiveETHUD</b></p><a name=\"SamhsaSensitiveETHUD\"> </a><a name=\"hcSamhsaSensitiveETHUD\"> </a><p><b>url</b>: <a href=\"ValueSet-SamhsaSensitiveETHUD.html\">clinical codes that indicate ETHUD</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SamhsaSensitiveETHUD</p><p><b>title</b>: clinical codes that indicate ETHUD</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2016-09-09</p><p><b>description</b>: </p><div><p>codes that when found in data would indicate the data is likely ETHUD related</p>\n<p>ETHUD - alcohol abuse information sensitivity (alcohol abuse information)</p>\n<ul>\n<li><strong>SAMHSA  C2S Alcohol Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC</li>\n</ul>\n</li>\n<li><strong>SAMHSA Test C2S Alcohol Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT</li>\n</ul>\n</li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode ETHUD}\">alcohol use disorder information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.1/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.2/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.3/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.4/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.5/expansion\">C2S Alcohol Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.65/expansion\">Test C2S Alcohol Use Disorders</a></p></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveETHUD",
        "version" : "0.1.0",
        "name" : "SamhsaSensitiveETHUD",
        "title" : "clinical codes that indicate ETHUD",
        "status" : "active",
        "experimental" : false,
        "date" : "2016-09-09",
        "description" : "codes that when found in data would indicate the data is likely ETHUD related\n\nETHUD - alcohol abuse information sensitivity (alcohol abuse information)\n\n* **SAMHSA  C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD\n  * ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD\n  * ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC\n* **SAMHSA Test C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "ETHUD"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.1"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.2"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.3"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.4"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.5"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.65"
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveOPIOIDUD",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SamhsaSensitiveOPIOIDUD",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SamhsaSensitiveOPIOIDUD\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SamhsaSensitiveOPIOIDUD</b></p><a name=\"SamhsaSensitiveOPIOIDUD\"> </a><a name=\"hcSamhsaSensitiveOPIOIDUD\"> </a><p><b>url</b>: <a href=\"ValueSet-SamhsaSensitiveOPIOIDUD.html\">clinical codes that indicate OPIOIDUD</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SamhsaSensitiveOPIOIDUD</p><p><b>title</b>: clinical codes that indicate OPIOIDUD</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2016-09-09</p><p><b>description</b>: </p><div><p>codes that when found in data would indicate the data is likely OPIOIDUD related</p>\n<p>OPIOIDUD - Opioid substance abuse information sensitivity (drug-abuse information)</p>\n<ul>\n<li><strong>SAMHSA C2S Amphetamine Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Cannabis Use Disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Cocaine Use Disorder</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Hallucinogens</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Inhalants</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Opioids</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Other Psychoactive Substance Use Disorder</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM</li>\n</ul>\n</li>\n<li><strong>SAMHSA C2S Substance use Information Sensitivity</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM</li>\n</ul>\n</li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode OPIOIDUD}\">opioid use disorder information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.10/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.11/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.6/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.7/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.8/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.9/expansion\">C2S Amphetamine Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.12/expansion\">C2S Cannabis Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.13/expansion\">C2S Cannabis Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.14/expansion\">C2S Cannabis Use Disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.15/expansion\">C2S Cannabis Use DIsorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.16/expansion\">C2S Cocaine Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.17/expansion\">C2S Cocaine Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.18/expansion\">C2S Cocaine Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.19/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.20/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.21/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.22/expansion\">C2S Hallucinogens</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.28/expansion\">C2S Inhalants</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.29/expansion\">C2S Inhalants</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.30/expansion\">C2S Inhalants</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.38/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.39/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.40/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.41/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.42/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.59/expansion\">C2S Opioids</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.43/expansion\">C2S Other Psychoactive Substance\nUse Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.44/expansion\">C2S Other Psychoactive Substance Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.45/expansion\">C2S Other Psychoactive Substance Use Disorder</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.46/expansion\">C2S Sedative Hypnotic, or anxiolytic related disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.47/expansion\">C2S Sedative Hypnotic, or anxiolytic related disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.48/expansion\">C2S Sedative Hypnotic, or anxiolytic related disorders</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.55/expansion\">C2S Substance Use Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.56/expansion\">C2S Substance Use Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.57/expansion\">C2S Substance Use Information Sensitivity</a></p></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveOPIOIDUD",
        "version" : "0.1.0",
        "name" : "SamhsaSensitiveOPIOIDUD",
        "title" : "clinical codes that indicate OPIOIDUD",
        "status" : "active",
        "experimental" : false,
        "date" : "2016-09-09",
        "description" : "codes that when found in data would indicate the data is likely OPIOIDUD related\n\nOPIOIDUD - Opioid substance abuse information sensitivity (drug-abuse information)\n\n* **SAMHSA C2S Amphetamine Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC\n* **SAMHSA C2S Cannabis Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT\n* **SAMHSA C2S Cocaine Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT\n* **SAMHSA C2S Hallucinogens**\n  * ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT\n* **SAMHSA C2S Inhalants**\n  * ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT\n* **SAMHSA C2S Opioids**\n  * ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT\n* **SAMHSA C2S Other Psychoactive Substance Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM\n* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM\n* **SAMHSA C2S Substance use Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "OPIOIDUD"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.10"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.11"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.6"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.7"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.8"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.9"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.12"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.13"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.14"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.15"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.16"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.17"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.18"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.19"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.20"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.21"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.22"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.28"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.29"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.30"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.38"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.39"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.40"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.41"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.42"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.59"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.43"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.44"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.45"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.46"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.47"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.48"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.55"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.56"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.57"
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveSDV",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SamhsaSensitiveSDV",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SamhsaSensitiveSDV\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SamhsaSensitiveSDV</b></p><a name=\"SamhsaSensitiveSDV\"> </a><a name=\"hcSamhsaSensitiveSDV\"> </a><p><b>url</b>: <a href=\"ValueSet-SamhsaSensitiveSDV.html\">clinical codes that indicate SDV</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SamhsaSensitiveSDV</p><p><b>title</b>: clinical codes that indicate SDV</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2016-09-09</p><p><b>description</b>: </p><div><p>SDV - Sexual assault, abuse or domestic violence</p>\n<p>??should this also include SEX (sexuality and reproductive health information sensitivity), PREGNANT (pregnancy), STD (sexually transmitted disease)? The SAMHSA valuesets seem to be labeled as if they are only about sexuality and reproductive health, but do include sexual abuse and sexually transmitted disease.</p>\n<ul>\n<li><strong>SAMHSA C2S Sexuality and reproductive health information sensitivity</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.49 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.50 // RXNORM</li>\n</ul>\n</li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode SDV}\">sexual assault, abuse, or domestic violence information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.49/expansion\">C2S Sexuality and reproductive health information sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.50/expansion\">C2S Sexuality and reproductive health information sensitivity</a></p></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveSDV",
        "version" : "0.1.0",
        "name" : "SamhsaSensitiveSDV",
        "title" : "clinical codes that indicate SDV",
        "status" : "active",
        "experimental" : false,
        "date" : "2016-09-09",
        "description" : "SDV - Sexual assault, abuse or domestic violence\n\n??should this also include SEX (sexuality and reproductive health information sensitivity), PREGNANT (pregnancy), STD (sexually transmitted disease)? The SAMHSA valuesets seem to be labeled as if they are only about sexuality and reproductive health, but do include sexual abuse and sexually transmitted disease.\n\n* **SAMHSA C2S Sexuality and reproductive health information sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.49 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.50 // RXNORM",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "SDV"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.49"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.50"
              ]
            }
          ]
        }
      }
    },
    {
      "fullUrl" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveHIV",
      "resource" : {
        "resourceType" : "ValueSet",
        "id" : "SamhsaSensitiveHIV",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"ValueSet_SamhsaSensitiveHIV\"> </a><p class=\"res-header-id\"><b>Generated Narrative: ValueSet SamhsaSensitiveHIV</b></p><a name=\"SamhsaSensitiveHIV\"> </a><a name=\"hcSamhsaSensitiveHIV\"> </a><p><b>url</b>: <a href=\"ValueSet-SamhsaSensitiveHIV.html\">clinical codes that indicate HIV</a></p><p><b>version</b>: 0.1.0</p><p><b>name</b>: SamhsaSensitiveHIV</p><p><b>title</b>: clinical codes that indicate HIV</p><p><b>status</b>: Active</p><p><b>experimental</b>: false</p><p><b>date</b>: 2016-09-09</p><p><b>description</b>: </p><div><p>HIV/AIDS information</p>\n<ul>\n<li><strong>SAMHSA C2S HIV/AIDS Information</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.23 // HCPCS</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.24 // ICD9CM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.25 // LOINC</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.26 // RXNORM</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.27 // SNOMED-CT</li>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.60 // CPT</li>\n</ul>\n</li>\n<li><strong>SAMHSA Test C2S HIV/AIDS Information Sensitivity</strong>\n<ul>\n<li>ValueSet 2.16.840.1.113762.1.4.1142.67 // SNOMEDCD</li>\n</ul>\n</li>\n</ul>\n</div><h3>UseContexts</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Code</b></td><td><b>Value[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-usage-context-type.html#usage-context-type-focus\">UsageContextType: focus</a> (Clinical Focus)</td><td><span title=\"Codes:{http://terminology.hl7.org/CodeSystem/v3-ActCode HIV}\">HIV/AIDS information sensitivity</span></td></tr></table><blockquote><p><b>compose</b></p><p><b>inactive</b>: true</p><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.23/expansion\">C2S HIV/AIDS Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.24/expansion\">C2S HIV/AIDS Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.25/expansion\">C2S HIV/AIDS Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.26/expansion\">C2S HIV/AIDS Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.27/expansion\">C2S HIV/AIDS Information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.60/expansion\">C2S HIV/AIDS information Sensitivity</a></p></blockquote><blockquote><p><b>include</b></p><p><b>valueSet</b>: <a href=\"https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.67/expansion\">Test C2S HIV/AIDS Information Sensitivity</a></p></blockquote></blockquote></div>"
        },
        "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SamhsaSensitiveHIV",
        "version" : "0.1.0",
        "name" : "SamhsaSensitiveHIV",
        "title" : "clinical codes that indicate HIV",
        "status" : "active",
        "experimental" : false,
        "date" : "2016-09-09",
        "description" : "HIV/AIDS information\n\n* **SAMHSA C2S HIV/AIDS Information**\n  * ValueSet 2.16.840.1.113762.1.4.1142.23 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.24 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.25 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.26 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.27 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.60 // CPT\n* **SAMHSA Test C2S HIV/AIDS Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.67 // SNOMEDCD",
        "useContext" : [
          {
            "code" : {
              "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
              "code" : "focus"
            },
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                  "code" : "HIV"
                }
              ]
            }
          }
        ],
        "compose" : {
          "inactive" : true,
          "include" : [
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.23"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.24"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.25"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.26"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.27"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.60"
              ]
            },
            {
              "valueSet" : [
                "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1142.67"
              ]
            }
          ]
        }
      }
    }
  ]
}

```
