# SHIFT IG Home - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **SHIFT IG Home**

## SHIFT IG Home

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ImplementationGuide/SHIFT-Task-Force.slsValueSets | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:ShiftSlsValueSets |

Privacy Consent driven access control through data sensitivity tagging. These ValueSets and SLS are in support of the [SHIFT Task Force's demo patients IG](https://build.fhir.org/ig/SHIFT-Task-Force/demo-fhir-data)

Published here are many variety of sensitive codes in ValueSets, but they are included only as examples. Formal ValueSet building is being done in HL7 as part of the [HL7 Cross-Paradigm Sensitive Data and Sensitivity Flags Library and Guidance](https://confluence.hl7.org/spaces/CGP/pages/321160258/Cross-Paradigm+Sensitive+Data+and+Sensitivity+Flags+Library+and+Guidance).

[Leap Security Labeling Service Discussion](sls.md) and Reference Implementation.

### SAMHSA

The following ValueSets are derived from the SAMHSA

SAMHSA big valueset - [https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.58/expansion/Latest](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113762.1.4.1142.58/expansion/Latest)

* [Set of codes that indicate ETH (alcohol and drug)](ValueSet-SamhsaSensitiveETH.md) 
* [Set of codes that indicate ETHUD (alcohol)](ValueSet-SamhsaSensitiveETHUD.md)
* [Set of codes that indicate OPIOIDUD (drugs)](ValueSet-SamhsaSensitiveOPIOIDUD.md)
 
* [Set of codes that indicate PSY](ValueSet-SamhsaSensitivePSY.md)
* [Set of codes that indicate SDV](ValueSet-SamhsaSensitiveSDV.md)
* [Set of codes that indicate HIV](ValueSet-SamhsaSensitiveHIV.md)
* [Bundle of SAMHSA Sensitive Kind Codes](Bundle-SamhsaSensitiveBundle.md)

### Synthea

See [An alternative ValueSets built off of the Synthea modules](synthea.md)

### California AB352 - HealthNet California

See [California AB352](ab352.md) ValueSets built from HealthNet California code lists.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "SHIFT-Task-Force.slsValueSets",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ImplementationGuide/SHIFT-Task-Force.slsValueSets",
  "version" : "0.1.0",
  "name" : "ShiftSlsValueSets",
  "title" : "SHIFT SLS ValueSets Implementation Guide",
  "status" : "active",
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "An Implementation Guide for Security Labeling Services (SLS) ValueSets developed by the SHIFT Task Force.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "packageId" : "SHIFT-Task-Force.slsValueSets",
  "license" : "CC-BY-4.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "us_nlm_vsac",
      "uri" : "http://fhir.org/packages/us.nlm.vsac/ImplementationGuide/us.nlm.vsac",
      "packageId" : "us.nlm.vsac",
      "version" : "0.19.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://SHIFT-Task-Force.github.io/slsValueSets/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "logging"
          },
          {
            "url" : "value",
            "valueString" : "progress"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://SHIFT-Task-Force.github.io/slsValueSets/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/Consent-AB352-Example-AllowAll"
        },
        "name" : "AB352 Organizational Privacy Consent - Allow All",
        "description" : "A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect Patient allowing all access.\n\n- permit TPO",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/Consent-AB352-Example2"
        },
        "name" : "AB352 Organizational Privacy Consent - breath",
        "description" : "A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect the statutory requirements, with auto-filter bypassed for in-state recipients.\n\nBreath first - not possible with R6 consent structure, but shown here for clarity.\n\n- permit TPO\n  - deny sensitive data [for TPO]\n  - permit in-state sensitive data [for TPO]",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/Consent-AB352-Example"
        },
        "name" : "AB352 Organizational Privacy Consent - depth",
        "description" : "A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect the statutory requirements, with auto-filter bypassed for in-state recipients.\n\n- permit TPO\n  - deny sensitive data [for TPO]\n    - permit in-state [sensitive data for TPO]",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Consent"
          }
        ],
        "reference" : {
          "reference" : "Consent/Consent-AB352-Example4"
        },
        "name" : "AB352 Organizational Privacy Consent - four deep",
        "description" : "A FHIR Consent instance that is an explicit consent for AB 352 protected data, with provisions that reflect the statutory requirements, with auto-filter bypassed for in-state recipients, and exception for data from 2014.\n\n- permit TPO for All data\n  - deny AB352sensitive data [for TPO] (essentially for out-of-state)\n    - permit in-state AB352 sensitive data [for TPO] (in-state, auto-filter bypassed)\n      - deny in-state AB352 sensitive data from 2014",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AB352SegmentationTags"
        },
        "name" : "AB352 Segmentation Tags",
        "description" : "ValueSet of security labels used to segment AB352-sensitive health information in meta.security.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/AB352ValueSetBundle"
        },
        "name" : "AB352 ValueSet Bundle",
        "description" : "A FHIR Bundle containing all ValueSets related to AB352 sensitive topics.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AB352AbortionTopicsHealthNet"
        },
        "name" : "Abortion-Related Health Topics (Health Net California)",
        "description" : "Health Net explains and references 500073-Abortion-DX-Code-List.pdf file primarily within its Provider Library and through Provider Bulletins related to legislative compliance. The specific explanation is found in the context of Assembly Bill (AB) 352, which mandates the segregation and protection of sensitive health data.\n\n**Where the Explanation is Located:**\n\n1. **Provider Bulletin 24-351 (New Laws Help Safeguard Privacy):** Health Net (and its affiliate Wellcare) issued this bulletin to explain the requirements of AB 352. The bulletin explicitly identifies abortion and abortion-related services as \"Sensitive Services\" that must be:\n   - Segregated from the rest of the patient's medical record.\n   - Excluded from automatic sharing with the California Data Exchange Framework (DxF).\n   - Protected from out-of-state subpoenas or investigations.\n   - **Reference:** [Wellcare/Health Net Bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/)\n\n2. **Health Net Provider Library - `Pregnancy Termination` Section:** The website hosts a dedicated page for pregnancy termination benefits. It explains that to comply with California laws (specifically SB 245 for cost-sharing and AB 352 for privacy), providers must use specific diagnosis codes. The 500073 PDF serves as the technical master list for these required codes.\n   - **Reference:** [Pregnancy Termination - Health Net Provider Library](https://providerlibrary.healthnetcalifornia.com/)\n\n3. **The PDF Itself:** The document title, `ICD-10-CM Codes for Abortion-Related Services,` is the direct label Health Net uses on its search results and directory pages to explain what the file contains. It lists codes ranging from O00 (Ectopic pregnancy) to Z33.2 (Encounter for elective termination).\n\n**How Health Net Directs Providers to Use This File:**\n\nAccording to the site's AB 352 guidance, Health Net recommends that IT and Billing departments download this PDF and use the listed codes to create firewalls in EHR systems. If a patient's record contains any code found in 500073-Abortion-DX-Code-List.pdf, the system should automatically:\n- Block that data from being sent to out-of-state entities.\n- Prevent the data from being discovered in automated health information exchanges.\n\n**Direct Link to the Document:** [500073-Abortion-DX-Code-List.pdf](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/500073-Abortion-DX-Code-List.pdf)\n\n**Note:** This list may not be all-inclusive and is subject to change.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/LeapSlsBundledSensitiveKindCodes"
        },
        "name" : "Bundle - Leap SLS Sensitive Kind Codes",
        "description" : "Leap SLS Bundle containing ValueSets representing kinds of sensitive information requiring special privacy protections",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/SamhsaSensitiveBundle"
        },
        "name" : "Bundle of all SAMHSA sensitive ValueSets",
        "description" : "A bundle containing all of the SAMHSA sensitive ValueSets defined in this file.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/ca-location"
        },
        "name" : "California Location",
        "description" : "Location resource representing California for use in Consent provisions.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SamhsaSensitiveETH"
        },
        "name" : "clinical codes that indicate ETH",
        "description" : "codes that when found in data would indicate the data is likely ETH related\n\nETH - substance abuse information sensitivity (alcohol or drug-abuse information)\n\n* **SAMHSA  C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD\n  * ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD\n  * ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC\n* **SAMHSA C2S Amphetamine Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC\n* **SAMHSA C2S Cannabis Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT\n* **SAMHSA C2S Cocaine Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT\n* **SAMHSA C2S Hallucinogens**\n  * ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT\n* **SAMHSA C2S Inhalants**\n  * ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT\n* **SAMHSA C2S Opioids**\n  * ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT\n* **SAMHSA C2S Other Psychoactive Substance Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM\n* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM\n* **SAMHSA C2S Substance use Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM\n* **SAMHSA Test C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SamhsaSensitiveETHJustRx"
        },
        "name" : "clinical codes that indicate ETH",
        "description" : "codes that when found in data would indicate the data is likely ETH related\n\nETH - substance abuse information sensitivity (alcohol or drug-abuse information)\n\nThese valueSets are `not maintained`, the codes in these valueSets are inactive/retired. However they don't show in some distributions of vsac such as the HL7 package.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SamhsaSensitiveETHUD"
        },
        "name" : "clinical codes that indicate ETHUD",
        "description" : "codes that when found in data would indicate the data is likely ETHUD related\n\nETHUD - alcohol abuse information sensitivity (alcohol abuse information)\n\n* **SAMHSA  C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.1 // SNOMEDCD\n  * ValueSet 2.16.840.1.113762.1.4.1142.2 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.3 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.4 // ICD10CD\n  * ValueSet 2.16.840.1.113762.1.4.1142.5 // LOINC\n* **SAMHSA Test C2S Alcohol Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.65 // SNOMED-CT",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SamhsaSensitiveHIV"
        },
        "name" : "clinical codes that indicate HIV",
        "description" : "HIV/AIDS information\n\n* **SAMHSA C2S HIV/AIDS Information**\n  * ValueSet 2.16.840.1.113762.1.4.1142.23 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.24 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.25 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.26 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.27 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.60 // CPT\n* **SAMHSA Test C2S HIV/AIDS Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.67 // SNOMEDCD",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SamhsaSensitiveOPIOIDUD"
        },
        "name" : "clinical codes that indicate OPIOIDUD",
        "description" : "codes that when found in data would indicate the data is likely OPIOIDUD related\n\nOPIOIDUD - Opioid substance abuse information sensitivity (drug-abuse information)\n\n* **SAMHSA C2S Amphetamine Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.10 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.11 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.6 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.7 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.8 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.9 // LOINC\n* **SAMHSA C2S Cannabis Use Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.12 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.13 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.14 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.15 // SNOMED-CT\n* **SAMHSA C2S Cocaine Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.16 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.17 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.18 // SNOMED-CT\n* **SAMHSA C2S Hallucinogens**\n  * ValueSet 2.16.840.1.113762.1.4.1142.19 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.20 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.21 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.22 // SNOMED-CT\n* **SAMHSA C2S Inhalants**\n  * ValueSet 2.16.840.1.113762.1.4.1142.28 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.29 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.30 // SNOMED-CT\n* **SAMHSA C2S Opioids**\n  * ValueSet 2.16.840.1.113762.1.4.1142.38 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.39 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.40 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.41 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.42 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.59 // CPT\n* **SAMHSA C2S Other Psychoactive Substance Use Disorder**\n  * ValueSet 2.16.840.1.113762.1.4.1142.43 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.44 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.45 // ICD10CM\n* **SAMHSA C2S Sedative Hypnotic, or anxiolytic related disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.46 // SNOMED-CT\n  * ValueSet 2.16.840.1.113762.1.4.1142.47 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.48 // ICD9CM\n* **SAMHSA C2S Substance use Information Sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.55 // HCPCS\n  * ValueSet 2.16.840.1.113762.1.4.1142.56 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.57 // RXNORM",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SamhsaSensitivePSY"
        },
        "name" : "clinical codes that indicate PSY",
        "description" : "codes that when found in data would indicate the data is likely PSY related\n\nPSY - psychiatry disorder information sensitivity\n\n??should this include MH (Mental Health), PSYTHPN (psychotherapy note), and SUD (substance use)??\n\n* **SAMHSA C2S Mental Health Disorders**\n  * ValueSet 2.16.840.1.113762.1.4.1142.32 // ICD10CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.33 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.34 // LOINC\n  * ValueSet 2.16.840.1.113762.1.4.1142.35 // RXNORM\n  * ValueSet 2.16.840.1.113762.1.4.1142.36 // SNOMED-CT",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SamhsaSensitiveSDV"
        },
        "name" : "clinical codes that indicate SDV",
        "description" : "SDV - Sexual assault, abuse or domestic violence\n\n??should this also include SEX (sexuality and reproductive health information sensitivity), PREGNANT (pregnancy), STD (sexually transmitted disease)? The SAMHSA valuesets seem to be labeled as if they are only about sexuality and reproductive health, but do include sexual abuse and sexually transmitted disease.\n\n* **SAMHSA C2S Sexuality and reproductive health information sensitivity**\n  * ValueSet 2.16.840.1.113762.1.4.1142.49 // ICD9CM\n  * ValueSet 2.16.840.1.113762.1.4.1142.50 // RXNORM",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AB352ContraceptionTopicsAi"
        },
        "name" : "Contraception-Related Health Topics",
        "description" : "Clinical concepts related to contraception drawn from LOINC, SNOMED CT, and ICD-10-CM.\nIntended for segmentation of sensitive reproductive health information under AB352.\n\nThis ValueSet does not include code recommendations from Health Net California. Health Net California does not have a single source document for contraception-related codes similar to their abortion-related code list. Instead, Health Net references multiple sources, including the DHCS Family PACT Code List, within various policy documents.\n\n- **Health Net Bulletin 24-351:** New Laws Help Safeguard Privacy ([View Link](https://providerlibrary.healthnetcalifornia.com/))\n- **Health Net Medi-Cal Provider Manual (Chapter 4):** Sensitive Services section ([Link to Manuals](https://providerlibrary.healthnetcalifornia.com/))\n- **Family PACT Policies:** Health Net adopts the DHCS Family PACT Code List as their baseline for identifying what constitutes a contraceptive service.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/AB352GenderAffirmingCareHealthNet"
        },
        "name" : "Gender-Affirming Care Codes (Health Net California)",
        "description" : "CPT and ICD-10-CM codes referenced in Health Net California's clinical policy\n'HNCA.CP.MP.496 - Gender Affirming Procedures'. Intended for segmentation of\ngender-affirming care under AB352.\n\n**Health Net Bulletin 24-351**\n\nHealth Net's [bulletin 24-351](https://providerlibrary.healthnetcalifornia.com/) explicitly tells providers that services defined in policies like HNCA.CP.MP.496 must be:\n\n- **Blocked from automatic sharing** with the California Data Exchange Framework (DxF).\n- **Omitted from responses** to out-of-state subpoenas or investigations.\n- **Flagged within the EHR** to prevent unauthorized access by users outside of California.\n\n**Where to Find and Download HNCA.CP.MP.496.pdf** Health Net maintains this policy in several locations within their provider libraries:\n\n- **Direct PDF Link:** [HNCA.CP.MP.496 - Gender Affirming Procedures](https://providerlibrary.healthnetcalifornia.com/content/dam/centene/healthnet/pdfs/providerlibrary/HNCA.CP.MP.496.pdf)\n- **The Provider Library Archive:** You can find this by navigating to Health Net Provider Library > Resources > Clinical Policies and searching for `Gender Affirming Procedures` or the code `496.`",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/AB352HealthSensitivityCs"
        },
        "name" : "Health Information Sensitivity Categories",
        "description" : "Code system defining sensitivity categories for health information segmentation under California AB352.\n\nNote did not use HL7 v2-ActCodes as two of the three categories are not represented there, and the GENDER code may be more broad than GENDER_AFFIRMING_CARE as intended here.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/SamhsaSensitive-initial-history"
        },
        "name" : "Initial creation of ValueSets PSY, ETH, SDV, and HIV",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/SamhsaSensitive-split-history"
        },
        "name" : "Split ETH into ETHUD and OPIOIDUD",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaAttentionDeficitDisorderVS"
        },
        "name" : "Synthea Codes for attention_deficit_disorder",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: attention_deficit_disorder.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaCerebralPalsyVS"
        },
        "name" : "Synthea Codes for cerebral_palsy",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: cerebral_palsy.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaCysticFibrosisVS"
        },
        "name" : "Synthea Codes for cystic_fibrosis",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: cystic_fibrosis.\n\nv3-ActCode#GDIS",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaDementiaVS"
        },
        "name" : "Synthea Codes for dementia",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: dementia.\n\nv3-ActCode#COGN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaOpioidAddictionVS"
        },
        "name" : "Synthea Codes for opioid_addiction",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: opioid_addiction.\n\nv3-ActCode#OPIOIDUD",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaPregnancyVS"
        },
        "name" : "Synthea Codes for pregnancy",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: pregnancy.\n\nv3-ActCode#PREGNANT",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaSelfHarmVS"
        },
        "name" : "Synthea Codes for self_harm",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: self_harm.\n\nv3-ActCode#SDV",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaSpinaBifidaVS"
        },
        "name" : "Synthea Codes for spina_bifida",
        "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: spina_bifida.\n\nv3-ActCode#GDIS",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaCognitiveVS"
        },
        "name" : "Synthea Cognitive Disability Codes",
        "description" : "A comprehensive ValueSet encompassing codes from all Synthea modules related to cognitive and neurological disabilities.\n\nv3-ActCode#COGN",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaGeneticVS"
        },
        "name" : "Synthea Genetic Disability Codes",
        "description" : "A comprehensive ValueSet encompassing codes from all Synthea modules related to genetic diseases.\n\nv3-ActCode#GDIS",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaMentalBehavioralHealthVS"
        },
        "name" : "Synthea Mental and Behavioral Health Codes",
        "description" : "A comprehensive ValueSet encompassing codes from all Synthea modules related to mental health conditions, including ADD, PTSD, and self-harm events.\n\nv3-ActCode#BH",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaReproductiveHealthVS"
        },
        "name" : "Synthea Reproductive Health Codes",
        "description" : "A comprehensive ValueSet encompassing codes from all Synthea modules related to reproductive health, including pregnancy, contraception, and sexual activity.\n\nv3-ActCode#SEX",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/SyntheaSensitiveValueSetsBundle"
        },
        "name" : "Synthea Sensitive Value Sets Bundle",
        "description" : "A FHIR Bundle containing all Synthea sensitive ValueSets.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/SyntheaSubstanceAbuseVS"
        },
        "name" : "Synthea Substance Abuse Codes",
        "description" : "A comprehensive ValueSet encompassing codes from all Synthea modules related to Opioid Addiction, OUD treatment, and chronic pain prescribing.\n\nv3-ActCode#SUD",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Provenance"
          }
        ],
        "reference" : {
          "reference" : "Provenance/SamhsaSensitive-update-history"
        },
        "name" : "touchup of ValueSets PSY, ETH, SDV, and HIV",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/LeapSlsBehavioralHealthCodes"
        },
        "name" : "ValueSet - Leap SLS Behavioral Health Codes",
        "description" : "Leap SLS set of codes representing behavioral health conditions requiring special privacy protections\n\nIdentified as: v3-ActCode#BH",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/LeapSlsHallucinogenCodes"
        },
        "name" : "ValueSet - Leap SLS Hallucinogen Codes",
        "description" : "Leap SLS set of codes representing hallucinogen abuse requiring special privacy protections\n\nIdentified as: SUD",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/LeapSlsOpioidCodes"
        },
        "name" : "ValueSet - Leap SLS Opioid Codes",
        "description" : "Leap SLS set of codes representing opioid abuse requiring special privacy protections.\n\nIdentified as: v3-ActCode#OPIOIDUD",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/LeapSlsPsychiatricNotesCodes"
        },
        "name" : "ValueSet - Leap SLS Psychiatric Notes Use Codes",
        "description" : "Leap SLS set of codes representing psychiatric notes requiring special privacy protections. \n\nIdentified as: PSYTHPN, BH",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/LeapSlsSensitiveCodes"
        },
        "name" : "ValueSet - Leap SLS Sensitive Kind Codes",
        "description" : "Leap SLS set of codes representing kinds of sensitive information requiring special privacy protections",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/LeapSlsSexualityAndReproductiveHealthCodes"
        },
        "name" : "ValueSet - Leap SLS Sexuality and Reproductive Health Codes",
        "description" : "Leap SLS set of codes representing sexuality and reproductive health requiring special privacy protections\n\nIdentified as: v3-ActCode#SEX",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "SHIFT IG Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "sls.html"
            }
          ],
          "nameUrl" : "sls.html",
          "title" : "Security Labeling Services (SLS)",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "synthea.html"
            }
          ],
          "nameUrl" : "synthea.html",
          "title" : "Synthea Modules Used",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "ab352.html"
            }
          ],
          "nameUrl" : "ab352.html",
          "title" : "California AB352 Use Case",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "download.html"
            }
          ],
          "nameUrl" : "download.html",
          "title" : "About and Download",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
