# California AB352 Use Case - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **California AB352 Use Case**

## California AB352 Use Case

let’s treat [AB 352](https://leginfo.legislature.ca.gov/faces/billTextClient.xhtml?bill_id=202120220AB352) as an organizational policy encoded as a top-level PolicySet that:

* Denies disclosure of certain sensitive data (abortion, gender‑affirming care, contraception, etc.) to out‑of‑state recipients.
* Applies to a hospital organization in California.
* Uses attributes to represent: 
* Data category (e.g., health:sensitivity).
* Recipient jurisdiction (e.g., recipient:jurisdiction).
* Purpose of use (optional, but useful).
* Action (e.g., disclose, access, use).
 

```
graph TD
    Start((Medical Record Action)) --> Destination{Destination?}

    %% IN-STATE FLOW
    Destination -->|CA Data Exchange| InState[<b>IN-STATE</b>]
    InState --> DxFGate{Specific Consent on File?}
    
    DxFGate -->|No| AutoFilter[<b>AUTO-FILTER: ENABLED</b>]
    AutoFilter -->|Action| Scrub[Scrub Sensitive Codes]
    Scrub --> SharePartial[Share General Data Only]
    
    DxFGate -->|Yes| FilterOff[<b>Follow Consent #40;AUTO-FILTER:disabled#41;</b>]
    FilterOff --> ShareFull[Share Consent Permitted Record via DxF]

    %% OUT-OF-STATE FLOW
    Destination -->|Cross Border| OutState[<b>OUT-OF-STATE</b>]
    OutState --> ShieldGate{Specific Consent on File?}
    
    ShieldGate -->|No| Block[<b>AB 352 SHIELD: BLOCKED</b>]
    Block --> Partial[Release Non-Sensitive Data Only]
    
    ShieldGate -->|Yes| Consented[<b>Follow Consent</b>]
    Consented --> Full[Release Consent Permitted Record]

    %% Formatting
    style AutoFilter fill:#fff4dd,stroke:#d4a017,stroke-width:2px
    style FilterOff fill:#9f9,stroke:#333
    style Block fill:#f99,stroke:#333

```

### ValueSets for AB 352

Generated by co-pilot with specific direction to use recommendations from HealthNet California AB 352 documentation.

[ValueSets](artifacts.md#terminology-value-sets):

* [AB352 Segmentation Sensitivity Codes](CodeSystem-AB352HealthSensitivityCs.md)
* ABORTION 
* [Abortion-Related Health Topics](ValueSet-AB352AbortionTopicsHealthNet.md)
 
* GENDER_AFFIRMING_CARE 
* [Gender-Affirming Care Codes](ValueSet-AB352GenderAffirmingCareHealthNet.md)
 
* CONTRACEPTION 
* [Contraception Topics (not HealthNet)](ValueSet-AB352ContraceptionTopicsAi.md)
 
* [Bundle of AB352 Segmentation Tags](Bundle-AB352ValueSetBundle.md)

### FHIR Consent with Policies

A FHIR [Consent instance](Consent-Consent-AB352-Example.md) that is an explicit consent for AB 352 protected data, with provisions that reflect the statutory requirements, with auto-filter bypassed for in-state recipients.

* `policyRule` → AB 352 statutory anchor ==> `urn:law:us:ca:statute:AB352`
* `policy` – see note below
* `patient` → the patient giving consent
* `organization` → the California hospital organization
* `dateTime` → when the consent was created
* `category` → Release of Information Consent LOINC code
* `scope` → Privacy Consent
* `provision[0]` → overall provision agreement for AB 352 data segmentation for TREATMENT purpose. 
* `type` → `permit`
* `purpose` → `TREATMENT`, `PAYMENT`, `OPERATIONS`
* `provision[0]` out-of-state recipients deny 
* `type` → `deny`
* no location means everywhere (out-of-state)
* `securityLabel` → three sensitivity tags from [AB352 Segmentation Tags ValueSet](ValueSet-AB352SegmentationTags.md)
* `purpose` → `TREATMENT`, `PAYMENT`, `OPERATIONS`
* `provision[0]` → Indicates that for in-state recipients, data tagged with specific sensitivity codes can be accessed for treatment purpose. (Auto-Filter is bypassed) 
* `type` → `permit`
* `location` → organization in California
* don't need to restate the purpose and securityLabel here since they are inherited from the parent provision.
 
 
 

Note that the `policy` element is not indicated here, as the policyRule code is sufficient to express to the recipient the statutory basis for the consent. If the Recipient does not understand the rules of AB352, then the encoded (e.g. XACML) PolicySet can be shared out-of-band or referenced via a URI. It is not clear what use the Recipient has for the actual XACML policy in the context of FHIR Consent, but it is included here for discussion sake. Many are arguing that the FHIR Consent must include the foundational rules in a computable form.

If the patient wants non-CA recipients to have access than provision[1] would be modified to `permit` instead of `deny`. If they want to enable only SOME out-of-state access, then multiple provisions would be needed for each authorized out-of-state organization.

### PDP Evaluation

```
flowchart TD

    A["Request to access/disclose data"] --> B["PEP collects attributes"]
    B --> C["Attributes: action, sensitivity, recipient jurisdiction, purpose"]
    C --> D["PDP evaluates PolicySet urn:org:hospital:policyset:AB352"]

    D --> E1{"Action = disclose?"}
    E1 -- Yes --> F1{"Sensitivity in AB352 set?"}
    F1 -- Yes --> G1{"Recipient jurisdiction != CA?"}
    G1 -- Yes --> H1["Deny<br/>Obligation: log-denial"]
    G1 -- No --> I1["Continue evaluation<br/>(local org policies)"]
    F1 -- No --> I1

    E1 -- No --> E2{"Action = access/use?"}
    E2 -- Yes --> F2{"Recipient jurisdiction = CA<br/>AND purpose = TREATMENT?"}
    F2 -- Yes --> H2["Permit<br/>Obligation: segment-sensitive-data"]
    F2 -- No --> I2["NotApplicable or other org policies"]

    E2 -- No --> I2

    H2 --> J["PEP enforces segmentation<br/>(EHR/HIE data segregation)"]
    H1 --> K["PEP denies disclosure<br/>and records AuditEvent"]


```

### PolicySet for AB 352

This treats AB 352 as an organizational policy implemented by a California hospital, expressed as a top‑level PolicySet with subordinate policies for:

* Denying disclosure of AB 352‑sensitive data to out‑of‑state entities
* Allowing in‑state treatment access
* Enforcing segmentation obligations (modeled as Obligations)

```
graph TD
    PS["<b>PolicySet:</b> AB352 Compliance<br/>Target: CA-HOSPITAL<br/>Combining Alg: Deny-Overrides"]
    
    PS --> P1_T
    PS --> P2_T
    PS --> P3_T

    %% Policy 1
    subgraph P1 ["Policy 1: Data Disclosure Control"]
        P1_T["Target: Action = DISCLOSE"]
        P1_R1["Rule: Deny Out-of-State"]
        P1_C{"Condition:<br/>Is Sensitive Health Data?<br/>AND Recipient != CA?"}
        P1_O["Obligation: Log Denial Reason"]
        
        P1_T --> P1_R1
        P1_R1 --> P1_C
        P1_R1 --> P1_O
    end

    %% Policy 2
    subgraph P2 ["Policy 2: In-State Clinical Use"]
        P2_T["Target: Action = ACCESS/USE"]
        P2_R1["Rule: Permit Treatment"]
        P2_C{"Condition:<br/>Recipient = CA?<br/>AND Purpose = TREATMENT?"}
        
        P2_T --> P2_R1
        P2_R1 --> P2_C
    end

    %% Policy 3
    subgraph P3 ["Policy 3: Mandatory Segmentation"]
        P3_T["Target: Any"]
        P3_R1["Rule: Permit"]
        P3_O["Obligation: Trigger Segmentation Engine<br/>for Abortion/Gender Care/Contraception"]
        
        P3_T --> P3_R1
        P3_R1 --> P3_O
    end

    %% Styling
    style PS fill:#f9f,stroke:#333,stroke-width:4px
    style P1_R1 fill:#ff9999,stroke:#c00
    style P2_R1 fill:#99ff99,stroke:#0c0
    style P3_O fill:#bbdaff,stroke:#00f

```

