# Synthea Codes for pregnancy - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for pregnancy**

## ValueSet: Synthea Codes for pregnancy 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaPregnancyVS | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:SyntheaPregnancyVS |
| **Usage:**Clinical Focus: pregnancy information sensitivity | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: pregnancy. 
v3-ActCode#PREGNANT 

 **References** 

* Included into [SyntheaReproductiveHealthVS](ValueSet-SyntheaReproductiveHealthVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaPregnancyVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaPregnancyVS",
  "version" : "0.1.0",
  "name" : "SyntheaPregnancyVS",
  "title" : "Synthea Codes for pregnancy",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: pregnancy.\n\nv3-ActCode#PREGNANT",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "PREGNANT"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "72892002"
          },
          {
            "code" : "424441002"
          },
          {
            "code" : "252160004"
          },
          {
            "code" : "169230002"
          },
          {
            "code" : "134435003"
          },
          {
            "code" : "274804006"
          },
          {
            "code" : "225158009"
          },
          {
            "code" : "44608003"
          },
          {
            "code" : "104091002"
          },
          {
            "code" : "47758006"
          },
          {
            "code" : "31676001"
          },
          {
            "code" : "310861008"
          },
          {
            "code" : "165829005"
          },
          {
            "code" : "269828009"
          },
          {
            "code" : "117010004"
          },
          {
            "code" : "90226004"
          },
          {
            "code" : "395123002"
          },
          {
            "code" : "104375008"
          },
          {
            "code" : "314098000"
          },
          {
            "code" : "104326007"
          },
          {
            "code" : "28163009"
          },
          {
            "code" : "60218003"
          },
          {
            "code" : "5880005"
          },
          {
            "code" : "47200007"
          },
          {
            "code" : "424619006"
          },
          {
            "code" : "443529005"
          },
          {
            "code" : "271442007"
          },
          {
            "code" : "275833003"
          },
          {
            "code" : "169673001"
          },
          {
            "code" : "51116004"
          },
          {
            "code" : "399014008"
          },
          {
            "code" : "268556000"
          },
          {
            "code" : "398254007"
          },
          {
            "code" : "198992004"
          },
          {
            "code" : "118001005"
          },
          {
            "code" : "183460006"
          },
          {
            "code" : "31208007"
          },
          {
            "code" : "18946005"
          },
          {
            "code" : "237001001"
          },
          {
            "code" : "85548006"
          },
          {
            "code" : "236974004"
          },
          {
            "code" : "177157003"
          },
          {
            "code" : "386216000"
          },
          {
            "code" : "367494004"
          },
          {
            "code" : "11466000"
          },
          {
            "code" : "19169002"
          },
          {
            "code" : "85116003"
          },
          {
            "code" : "156073000"
          },
          {
            "code" : "35999006"
          },
          {
            "code" : "305408004"
          },
          {
            "code" : "236931002"
          },
          {
            "code" : "445912000"
          },
          {
            "code" : "267253006"
          },
          {
            "code" : "37849005"
          },
          {
            "code" : "609496007"
          },
          {
            "code" : "171207006"
          },
          {
            "code" : "270427003"
          },
          {
            "code" : "10383002"
          },
          {
            "code" : "714812005"
          },
          {
            "code" : "386394001"
          },
          {
            "code" : "169762003"
          },
          {
            "code" : "133899007"
          },
          {
            "code" : "79586000"
          },
          {
            "code" : "161744009"
          }
        ]
      }
    ]
  }
}

```
