# Synthea Codes for dementia - SHIFT SLS ValueSets Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Synthea Codes for dementia**

## ValueSet: Synthea Codes for dementia 

| | |
| :--- | :--- |
| *Official URL*:http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaDementiaVS | *Version*:0.1.0 |
| Active as of 2026-02-05 | *Computable Name*:SyntheaDementiaVS |
| **Usage:**Clinical Focus: cognitive disability information sensitivity | |

 
A ValueSet containing all clinical codes found in the sensitive Synthea module: dementia. 
v3-ActCode#COGN 

 **References** 

* Included into [SyntheaCognitiveVS](ValueSet-SyntheaCognitiveVS.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "SyntheaDementiaVS",
  "url" : "http://SHIFT-Task-Force.github.io/slsValueSets/ValueSet/SyntheaDementiaVS",
  "version" : "0.1.0",
  "name" : "SyntheaDementiaVS",
  "title" : "Synthea Codes for dementia",
  "status" : "active",
  "experimental" : false,
  "date" : "2026-02-05T19:41:35+00:00",
  "publisher" : "SHIFT-Task-Force",
  "contact" : [
    {
      "name" : "SHIFT-Task-Force",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://shift-project.org"
        }
      ]
    }
  ],
  "description" : "A ValueSet containing all clinical codes found in the sensitive Synthea module: dementia.\n\nv3-ActCode#COGN",
  "useContext" : [
    {
      "code" : {
        "system" : "http://terminology.hl7.org/CodeSystem/usage-context-type",
        "code" : "focus"
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
            "code" : "COGN"
          }
        ]
      }
    }
  ],
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "001"
        }
      ]
    }
  ],
  "compose" : {
    "inactive" : true,
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "26929004"
          },
          {
            "code" : "230265002"
          },
          {
            "code" : "386257007"
          },
          {
            "code" : "281036007"
          },
          {
            "code" : "233604007"
          },
          {
            "code" : "4525004"
          }
        ]
      },
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "72106-8"
          }
        ]
      },
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "concept" : [
          {
            "code" : "310436"
          },
          {
            "code" : "997223"
          },
          {
            "code" : "313185"
          },
          {
            "code" : "1599803"
          },
          {
            "code" : "996740"
          },
          {
            "code" : "1100184"
          }
        ]
      }
    ]
  }
}

```
